/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.DatasetFragment;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.FragmentOperation;
import com.lancedb.lance.JniLoader;
import com.lancedb.lance.LockManager;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import java.io.Closeable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.pojo.Schema;

public class Dataset
implements Closeable {
    private long nativeDatasetHandle;
    BufferAllocator allocator;
    private final LockManager lockManager = new LockManager();

    private Dataset() {
    }

    public static Dataset create(BufferAllocator allocator, String path, Schema schema, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkNotNull((Object)params);
        try (ArrowSchema arrowSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);){
            Data.exportSchema((BufferAllocator)allocator, (Schema)schema, null, (ArrowSchema)arrowSchema);
            Dataset dataset = Dataset.createWithFfiSchema(arrowSchema.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode());
            dataset.allocator = allocator;
            Dataset dataset2 = dataset;
            return dataset2;
        }
    }

    public static Dataset create(BufferAllocator allocator, ArrowArrayStream stream, String path, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)params);
        Dataset dataset = Dataset.createWithFfiStream(stream.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode());
        dataset.allocator = allocator;
        return dataset;
    }

    private static native Dataset createWithFfiSchema(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6);

    private static native Dataset createWithFfiStream(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6);

    public static Dataset open(String path, BufferAllocator allocator) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)allocator);
        Dataset dataset = Dataset.openNative(path);
        dataset.allocator = allocator;
        return dataset;
    }

    public static native Dataset openNative(String var0);

    public static Dataset commit(BufferAllocator allocator, String path, FragmentOperation operation, Optional<Long> readVersion) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)operation);
        Preconditions.checkNotNull(readVersion);
        Dataset dataset = operation.commit(allocator, path, readVersion);
        dataset.allocator = allocator;
        return dataset;
    }

    public static native Dataset commitAppend(String var0, Optional<Long> var1, List<String> var2);

    public LanceScanner newScan() {
        return this.newScan(new ScanOptions.Builder().build());
    }

    public LanceScanner newScan(long batchSize) {
        return this.newScan(new ScanOptions.Builder().batchSize(batchSize).build());
    }

    public LanceScanner newScan(ScanOptions options) {
        Preconditions.checkNotNull((Object)options);
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            LanceScanner lanceScanner = LanceScanner.create(this, options, this.allocator);
            return lanceScanner;
        }
    }

    public long version() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeVersion();
            return l;
        }
    }

    private native long nativeVersion();

    public long latestVersion() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeLatestVersion();
            return l;
        }
    }

    private native long nativeLatestVersion();

    public int countRows() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            int n = this.nativeCountRows();
            return n;
        }
    }

    private native int nativeCountRows();

    public List<DatasetFragment> getFragments() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<DatasetFragment> list = this.getJsonFragments().stream().map(jsonFragment -> new DatasetFragment(this, FragmentMetadata.fromJson(jsonFragment))).collect(Collectors.toList());
            return list;
        }
    }

    private native List<String> getJsonFragments();

    /*
     * Exception decompiling
     */
    public Schema getSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private native void importFfiSchema(long var1);

    @Override
    public void close() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            if (this.nativeDatasetHandle != 0L) {
                this.releaseNativeDataset(this.nativeDatasetHandle);
                this.nativeDatasetHandle = 0L;
            }
        }
    }

    private native void releaseNativeDataset(long var1);

    public boolean closed() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            boolean bl = this.nativeDatasetHandle == 0L;
            return bl;
        }
    }

    static {
        JniLoader.ensureLoaded();
    }
}

