/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import java.util.Optional;

public class WriteParams {
    private final Optional<Integer> maxRowsPerFile;
    private final Optional<Integer> maxRowsPerGroup;
    private final Optional<Long> maxBytesPerFile;
    private final Optional<WriteMode> mode;

    private WriteParams(Optional<Integer> maxRowsPerFile, Optional<Integer> maxRowsPerGroup, Optional<Long> maxBytesPerFile, Optional<WriteMode> mode) {
        this.maxRowsPerFile = maxRowsPerFile;
        this.maxRowsPerGroup = maxRowsPerGroup;
        this.maxBytesPerFile = maxBytesPerFile;
        this.mode = mode;
    }

    public Optional<Integer> getMaxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    public Optional<Integer> getMaxRowsPerGroup() {
        return this.maxRowsPerGroup;
    }

    public Optional<Long> getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    public Optional<String> getMode() {
        return this.mode.map(Enum::name);
    }

    public static class Builder {
        private Optional<Integer> maxRowsPerFile = Optional.empty();
        private Optional<Integer> maxRowsPerGroup = Optional.empty();
        private Optional<Long> maxBytesPerFile = Optional.empty();
        private Optional<WriteMode> mode = Optional.empty();

        public Builder withMaxRowsPerFile(int maxRowsPerFile) {
            this.maxRowsPerFile = Optional.of(maxRowsPerFile);
            return this;
        }

        public Builder withMaxRowsPerGroup(int maxRowsPerGroup) {
            this.maxRowsPerGroup = Optional.of(maxRowsPerGroup);
            return this;
        }

        public Builder withMaxBytesPerFile(long maxBytesPerFile) {
            this.maxBytesPerFile = Optional.of(maxBytesPerFile);
            return this;
        }

        public Builder withMode(WriteMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        public WriteParams build() {
            return new WriteParams(this.maxRowsPerFile, this.maxRowsPerGroup, this.maxBytesPerFile, this.mode);
        }
    }

    public static enum WriteMode {
        CREATE,
        APPEND,
        OVERWRITE;

    }
}

