/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.ipc;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.util.Preconditions;

public class ScanOptions {
    private final Optional<List<Integer>> fragmentIds;
    private final Optional<Long> batchSize;
    private final Optional<List<String>> columns;
    private final Optional<String> filter;
    private final Optional<ByteBuffer> substraitFilter;

    public ScanOptions(Optional<List<Integer>> fragmentIds, Optional<Long> batchSize, Optional<List<String>> columns, Optional<String> filter, Optional<ByteBuffer> substraitFilter) {
        Preconditions.checkArgument((!filter.isPresent() || !substraitFilter.isPresent() ? 1 : 0) != 0, (Object)"cannot set both substrait filter and string filter");
        this.fragmentIds = fragmentIds;
        this.batchSize = batchSize;
        this.columns = columns;
        this.filter = filter;
        this.substraitFilter = substraitFilter;
    }

    public Optional<List<Integer>> getFragmentIds() {
        return this.fragmentIds;
    }

    public Optional<Long> getBatchSize() {
        return this.batchSize;
    }

    public Optional<List<String>> getColumns() {
        return this.columns;
    }

    public Optional<String> getFilter() {
        return this.filter;
    }

    public Optional<ByteBuffer> getSubstraitFilter() {
        return this.substraitFilter;
    }

    public static class Builder {
        private Optional<List<Integer>> fragmentIds = Optional.empty();
        private Optional<Long> batchSize = Optional.empty();
        private Optional<List<String>> columns = Optional.empty();
        private Optional<String> filter = Optional.empty();
        private Optional<ByteBuffer> substraitFilter = Optional.empty();

        public Builder() {
        }

        public Builder(ScanOptions options) {
            this.fragmentIds = options.getFragmentIds();
            this.batchSize = options.getBatchSize();
            this.columns = options.getColumns();
            this.filter = options.getFilter();
            this.substraitFilter = options.getSubstraitFilter();
        }

        public Builder fragmentIds(List<Integer> fragmentIds) {
            this.fragmentIds = Optional.of(fragmentIds);
            return this;
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = Optional.of(batchSize);
            return this;
        }

        public Builder columns(List<String> columns) {
            Preconditions.checkNotNull(columns);
            this.columns = Optional.of(columns);
            return this;
        }

        public Builder filter(String filter) {
            Preconditions.checkNotNull((Object)filter);
            this.filter = Optional.of(filter);
            return this;
        }

        public Builder substraitFilter(ByteBuffer substraitFilter) {
            Preconditions.checkNotNull((Object)substraitFilter);
            this.substraitFilter = Optional.of(substraitFilter);
            return this;
        }

        public ScanOptions build() {
            return new ScanOptions(this.fragmentIds, this.batchSize, this.columns, this.filter, this.substraitFilter);
        }
    }
}

