/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import java.util.Arrays;
import org.apache.arrow.util.Preconditions;

public class DatasetFragment {
    private final Dataset dataset;
    private final FragmentMetadata metadata;

    DatasetFragment(Dataset dataset, FragmentMetadata metadata) {
        Preconditions.checkNotNull((Object)dataset);
        Preconditions.checkNotNull((Object)metadata);
        this.dataset = dataset;
        this.metadata = metadata;
    }

    public LanceScanner newScan() {
        return LanceScanner.create(this.dataset, new ScanOptions.Builder().fragmentIds(Arrays.asList(this.metadata.getId())).build(), this.dataset.allocator);
    }

    public LanceScanner newScan(long batchSize) {
        return LanceScanner.create(this.dataset, new ScanOptions.Builder().fragmentIds(Arrays.asList(this.metadata.getId())).batchSize(batchSize).build(), this.dataset.allocator);
    }

    public LanceScanner newScan(ScanOptions options) {
        Preconditions.checkNotNull((Object)options);
        return LanceScanner.create(this.dataset, new ScanOptions.Builder(options).fragmentIds(Arrays.asList(this.metadata.getId())).build(), this.dataset.allocator);
    }

    private native int countRowsNative(Dataset var1, long var2);

    public int getId() {
        return this.metadata.getId();
    }

    public int countRows() {
        return this.countRowsNative(this.dataset, this.metadata.getId());
    }

    public String toString() {
        return String.format("Fragment(%s)", this.metadata.getJsonMetadata());
    }
}

