/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import java.io.Serializable;
import org.apache.arrow.util.Preconditions;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.json.JSONObject;

public class FragmentMetadata
implements Serializable {
    private static final long serialVersionUID = -5886811251944130460L;
    private static final String ID_KEY = "id";
    private static final String PHYSICAL_ROWS_KEY = "physical_rows";
    private final String jsonMetadata;
    private final int id;
    private final long physicalRows;

    private FragmentMetadata(String jsonMetadata, int id, long physicalRows) {
        this.jsonMetadata = jsonMetadata;
        this.id = id;
        this.physicalRows = physicalRows;
    }

    public int getId() {
        return this.id;
    }

    public long getPhysicalRows() {
        return this.physicalRows;
    }

    public String getJsonMetadata() {
        return this.jsonMetadata;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(ID_KEY, this.id).append("physicalRows", this.physicalRows).append("jsonMetadata", (Object)this.jsonMetadata).toString();
    }

    public static FragmentMetadata fromJson(String jsonMetadata) {
        Preconditions.checkNotNull((Object)jsonMetadata);
        JSONObject metadata = new JSONObject(jsonMetadata);
        if (!metadata.has(ID_KEY) || !metadata.has(PHYSICAL_ROWS_KEY)) {
            throw new IllegalArgumentException(String.format("Fragment metadata must have {} and {} but is {}", ID_KEY, PHYSICAL_ROWS_KEY, jsonMetadata));
        }
        return new FragmentMetadata(jsonMetadata, metadata.getInt(ID_KEY), metadata.getLong(PHYSICAL_ROWS_KEY));
    }
}

