/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.FragmentMetadata;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;

public abstract class FragmentOperation {
    protected static void validateFragments(List<FragmentMetadata> fragments) {
        if (fragments == null || fragments.isEmpty()) {
            throw new IllegalArgumentException("fragments cannot be null or empty");
        }
    }

    public abstract Dataset commit(BufferAllocator var1, String var2, Optional<Long> var3);

    public static class Append
    extends FragmentOperation {
        private final List<FragmentMetadata> fragments;

        public Append(List<FragmentMetadata> fragments) {
            Append.validateFragments(fragments);
            this.fragments = fragments;
        }

        @Override
        public Dataset commit(BufferAllocator allocator, String path, Optional<Long> readVersion) {
            Preconditions.checkNotNull((Object)allocator);
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkNotNull(readVersion);
            return Dataset.commitAppend(path, readVersion, this.fragments.stream().map(FragmentMetadata::getJsonMetadata).collect(Collectors.toList()));
        }
    }
}

