/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.ipc;

import com.lancedb.lance.ipc.Query;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.util.Preconditions;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ScanOptions {
    private final Optional<List<Integer>> fragmentIds;
    private final Optional<Long> batchSize;
    private final Optional<List<String>> columns;
    private final Optional<String> filter;
    private final Optional<ByteBuffer> substraitFilter;
    private final Optional<Long> limit;
    private final Optional<Long> offset;
    private final Optional<Query> nearest;
    private final boolean withRowId;
    private final int batchReadahead;

    public ScanOptions(Optional<List<Integer>> fragmentIds, Optional<Long> batchSize, Optional<List<String>> columns, Optional<String> filter, Optional<ByteBuffer> substraitFilter, Optional<Long> limit, Optional<Long> offset, Optional<Query> nearest, boolean withRowId, int batchReadahead) {
        Preconditions.checkArgument((!filter.isPresent() || !substraitFilter.isPresent() ? 1 : 0) != 0, (Object)"cannot set both substrait filter and string filter");
        this.fragmentIds = fragmentIds;
        this.batchSize = batchSize;
        this.columns = columns;
        this.filter = filter;
        this.substraitFilter = substraitFilter;
        this.limit = limit;
        this.offset = offset;
        this.nearest = nearest;
        this.withRowId = withRowId;
        this.batchReadahead = batchReadahead;
    }

    public Optional<List<Integer>> getFragmentIds() {
        return this.fragmentIds;
    }

    public Optional<Long> getBatchSize() {
        return this.batchSize;
    }

    public Optional<List<String>> getColumns() {
        return this.columns;
    }

    public Optional<String> getFilter() {
        return this.filter;
    }

    public Optional<ByteBuffer> getSubstraitFilter() {
        return this.substraitFilter;
    }

    public Optional<Long> getLimit() {
        return this.limit;
    }

    public Optional<Long> getOffset() {
        return this.offset;
    }

    public Optional<Query> getNearest() {
        return this.nearest;
    }

    public boolean isWithRowId() {
        return this.withRowId;
    }

    public int getBatchReadahead() {
        return this.batchReadahead;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fragmentIds", this.fragmentIds.orElse(null)).append("batchSize", this.batchSize.orElse(null)).append("columns", this.columns.orElse(null)).append("filter", this.filter.orElse(null)).append("substraitFilter", this.substraitFilter.map(buf -> "ByteBuffer[" + buf.remaining() + " bytes]").orElse(null)).append("limit", this.limit.orElse(null)).append("offset", this.offset.orElse(null)).append("nearest", this.nearest.orElse(null)).append("withRowId", this.withRowId).append("batchReadahead", this.batchReadahead).toString();
    }

    public static class Builder {
        private Optional<List<Integer>> fragmentIds = Optional.empty();
        private Optional<Long> batchSize = Optional.empty();
        private Optional<List<String>> columns = Optional.empty();
        private Optional<String> filter = Optional.empty();
        private Optional<ByteBuffer> substraitFilter = Optional.empty();
        private Optional<Long> limit = Optional.empty();
        private Optional<Long> offset = Optional.empty();
        private Optional<Query> nearest = Optional.empty();
        private boolean withRowId = false;
        private int batchReadahead = 16;

        public Builder() {
        }

        public Builder(ScanOptions options) {
            this.fragmentIds = options.getFragmentIds();
            this.batchSize = options.getBatchSize();
            this.columns = options.getColumns();
            this.filter = options.getFilter();
            this.substraitFilter = options.getSubstraitFilter();
            this.limit = options.getLimit();
            this.offset = options.getOffset();
            this.nearest = options.getNearest();
            this.withRowId = options.isWithRowId();
            this.batchReadahead = options.getBatchReadahead();
        }

        public Builder fragmentIds(List<Integer> fragmentIds) {
            this.fragmentIds = Optional.of(fragmentIds);
            return this;
        }

        public Builder batchSize(long batchSize) {
            this.batchSize = Optional.of(batchSize);
            return this;
        }

        public Builder columns(List<String> columns) {
            this.columns = Optional.of(columns);
            return this;
        }

        public Builder filter(String filter) {
            this.filter = Optional.of(filter);
            return this;
        }

        public Builder substraitFilter(ByteBuffer substraitFilter) {
            this.substraitFilter = Optional.of(substraitFilter);
            return this;
        }

        public Builder limit(long limit) {
            this.limit = Optional.of(limit);
            return this;
        }

        public Builder offset(long offset) {
            this.offset = Optional.of(offset);
            return this;
        }

        public Builder nearest(Query nearest) {
            this.nearest = Optional.of(nearest);
            return this;
        }

        public Builder withRowId(boolean withRowId) {
            this.withRowId = withRowId;
            return this;
        }

        public Builder batchReadahead(int batchReadahead) {
            this.batchReadahead = batchReadahead;
            return this;
        }

        public ScanOptions build() {
            return new ScanOptions(this.fragmentIds, this.batchSize, this.columns, this.filter, this.substraitFilter, this.limit, this.offset, this.nearest, this.withRowId, this.batchReadahead);
        }
    }
}

