/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ReadOptions {
    private final Optional<Integer> version;
    private final Optional<Integer> blockSize;
    private final int indexCacheSize;
    private final int metadataCacheSize;
    private final Map<String, String> storageOptions;

    private ReadOptions(Builder builder) {
        this.version = builder.version;
        this.blockSize = builder.blockSize;
        this.indexCacheSize = builder.indexCacheSize;
        this.metadataCacheSize = builder.metadataCacheSize;
        this.storageOptions = builder.storageOptions;
    }

    public Optional<Integer> getVersion() {
        return this.version;
    }

    public Optional<Integer> getBlockSize() {
        return this.blockSize;
    }

    public int getIndexCacheSize() {
        return this.indexCacheSize;
    }

    public int getMetadataCacheSize() {
        return this.metadataCacheSize;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", this.version.orElse(null)).append("blockSize", this.blockSize.orElse(null)).append("indexCacheSize", this.indexCacheSize).append("metadataCacheSize", this.metadataCacheSize).append("storageOptions", this.storageOptions).toString();
    }

    public static class Builder {
        private Optional<Integer> version = Optional.empty();
        private Optional<Integer> blockSize = Optional.empty();
        private int indexCacheSize = 256;
        private int metadataCacheSize = 256;
        private Map<String, String> storageOptions = new HashMap<String, String>();

        public Builder setVersion(int version) {
            this.version = Optional.of(version);
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = Optional.of(blockSize);
            return this;
        }

        public Builder setIndexCacheSize(int indexCacheSize) {
            this.indexCacheSize = indexCacheSize;
            return this;
        }

        public Builder setMetadataCacheSize(int metadataCacheSize) {
            this.metadataCacheSize = metadataCacheSize;
            return this;
        }

        public Builder setStorageOptions(Map<String, String> storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

