/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.Fragment;
import com.lancedb.lance.FragmentMetadata;
import com.lancedb.lance.FragmentOperation;
import com.lancedb.lance.JniLoader;
import com.lancedb.lance.LockManager;
import com.lancedb.lance.ReadOptions;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.index.IndexParams;
import com.lancedb.lance.index.IndexType;
import com.lancedb.lance.ipc.DataStatistics;
import com.lancedb.lance.ipc.LanceScanner;
import com.lancedb.lance.ipc.ScanOptions;
import com.lancedb.lance.schema.ColumnAlteration;
import com.lancedb.lance.schema.SqlExpressions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.arrow.c.ArrowArrayStream;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.types.pojo.Schema;

public class Dataset
implements Closeable {
    private long nativeDatasetHandle;
    BufferAllocator allocator;
    boolean selfManagedAllocator = false;
    private final LockManager lockManager = new LockManager();

    private Dataset() {
    }

    public static Dataset create(BufferAllocator allocator, String path, Schema schema, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)schema);
        Preconditions.checkNotNull((Object)params);
        try (ArrowSchema arrowSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);){
            Data.exportSchema((BufferAllocator)allocator, (Schema)schema, null, (ArrowSchema)arrowSchema);
            Dataset dataset = Dataset.createWithFfiSchema(arrowSchema.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode(), params.getStorageOptions());
            dataset.allocator = allocator;
            Dataset dataset2 = dataset;
            return dataset2;
        }
    }

    public static Dataset create(BufferAllocator allocator, ArrowArrayStream stream, String path, WriteParams params) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)params);
        Dataset dataset = Dataset.createWithFfiStream(stream.memoryAddress(), path, params.getMaxRowsPerFile(), params.getMaxRowsPerGroup(), params.getMaxBytesPerFile(), params.getMode(), params.getStorageOptions());
        dataset.allocator = allocator;
        return dataset;
    }

    private static native Dataset createWithFfiSchema(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6, Map<String, String> var7);

    private static native Dataset createWithFfiStream(long var0, String var2, Optional<Integer> var3, Optional<Integer> var4, Optional<Long> var5, Optional<String> var6, Map<String, String> var7);

    public static Dataset open(String path) {
        return Dataset.open((BufferAllocator)new RootAllocator(Long.MAX_VALUE), true, path, new ReadOptions.Builder().build());
    }

    public static Dataset open(String path, ReadOptions options) {
        return Dataset.open((BufferAllocator)new RootAllocator(Long.MAX_VALUE), true, path, options);
    }

    public static Dataset open(String path, BufferAllocator allocator) {
        return Dataset.open(allocator, path, new ReadOptions.Builder().build());
    }

    public static Dataset open(BufferAllocator allocator, String path, ReadOptions options) {
        return Dataset.open(allocator, false, path, options);
    }

    private static Dataset open(BufferAllocator allocator, boolean selfManagedAllocator, String path, ReadOptions options) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)options);
        Dataset dataset = Dataset.openNative(path, options.getVersion(), options.getBlockSize(), options.getIndexCacheSize(), options.getMetadataCacheSize(), options.getStorageOptions());
        dataset.allocator = allocator;
        dataset.selfManagedAllocator = selfManagedAllocator;
        return dataset;
    }

    private static native Dataset openNative(String var0, Optional<Integer> var1, Optional<Integer> var2, int var3, int var4, Map<String, String> var5);

    public static Dataset commit(BufferAllocator allocator, String path, FragmentOperation operation, Optional<Long> readVersion) {
        return Dataset.commit(allocator, path, operation, readVersion, new HashMap<String, String>());
    }

    public static Dataset commit(BufferAllocator allocator, String path, FragmentOperation operation, Optional<Long> readVersion, Map<String, String> storageOptions) {
        Preconditions.checkNotNull((Object)allocator);
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)operation);
        Preconditions.checkNotNull(readVersion);
        Dataset dataset = operation.commit(allocator, path, readVersion, storageOptions);
        dataset.allocator = allocator;
        return dataset;
    }

    public static native Dataset commitAppend(String var0, Optional<Long> var1, List<FragmentMetadata> var2, Map<String, String> var3);

    public static native Dataset commitOverwrite(String var0, long var1, Optional<Long> var3, List<FragmentMetadata> var4, Map<String, String> var5);

    public static native void drop(String var0, Map<String, String> var1);

    public void addColumns(SqlExpressions sqlExpressions, Optional<Long> batchSize) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAddColumnsBySqlExpressions(sqlExpressions, batchSize);
        }
    }

    private native void nativeAddColumnsBySqlExpressions(SqlExpressions var1, Optional<Long> var2);

    public void addColumns(ArrowArrayStream stream, Optional<Long> batchSize) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAddColumnsByReader(stream.memoryAddress(), batchSize);
        }
    }

    private native void nativeAddColumnsByReader(long var1, Optional<Long> var3);

    public void dropColumns(List<String> columns) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeDropColumns(columns);
        }
    }

    private native void nativeDropColumns(List<String> var1);

    public void alterColumns(List<ColumnAlteration> columnAlterations) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeAlterColumns(columnAlterations);
        }
    }

    private native void nativeAlterColumns(List<ColumnAlteration> var1);

    public LanceScanner newScan() {
        return this.newScan(new ScanOptions.Builder().build());
    }

    public LanceScanner newScan(long batchSize) {
        return this.newScan(new ScanOptions.Builder().batchSize(batchSize).build());
    }

    public LanceScanner newScan(ScanOptions options) {
        Preconditions.checkNotNull((Object)options);
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            LanceScanner lanceScanner = LanceScanner.create(this, options, this.allocator);
            return lanceScanner;
        }
    }

    public ArrowReader take(List<Long> indices, List<String> columns) throws IOException {
        Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            byte[] arrowData = this.nativeTake(indices, columns);
            final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(arrowData);
            final ReadableByteChannel readChannel = Channels.newChannel(byteArrayInputStream);
            ArrowStreamReader arrowStreamReader = new ArrowStreamReader(readChannel, this.allocator){

                public void close() throws IOException {
                    super.close();
                    readChannel.close();
                    byteArrayInputStream.close();
                }
            };
            return arrowStreamReader;
        }
    }

    private native byte[] nativeTake(List<Long> var1, List<String> var2);

    public void delete(String predicate) {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeDelete(predicate);
        }
    }

    private native void nativeDelete(String var1);

    public String uri() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            String string = this.nativeUri();
            return string;
        }
    }

    private native String nativeUri();

    public long version() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeVersion();
            return l;
        }
    }

    private native long nativeVersion();

    public long latestVersion() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeLatestVersion();
            return l;
        }
    }

    private native long nativeLatestVersion();

    public void createIndex(List<String> columns, IndexType indexType, Optional<String> name, IndexParams params, boolean replace) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            this.nativeCreateIndex(columns, indexType.getValue(), name, params, replace);
        }
    }

    private native void nativeCreateIndex(List<String> var1, int var2, Optional<String> var3, IndexParams var4, boolean var5);

    public long countRows() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeCountRows(Optional.empty());
            return l;
        }
    }

    public long countRows(String filter) {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            Preconditions.checkArgument((null != filter && !filter.isEmpty() ? 1 : 0) != 0, (Object)"filter cannot be null or empty");
            long l = this.nativeCountRows(Optional.of(filter));
            return l;
        }
    }

    private native long nativeCountRows(Optional<String> var1);

    public long calculateDataSize() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            long l = this.nativeGetDataStatistics().getDataSize();
            return l;
        }
    }

    private native DataStatistics nativeGetDataStatistics();

    public List<Fragment> getFragments() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<Fragment> list = this.getFragmentsNative().stream().map(metadata -> new Fragment(this, (FragmentMetadata)metadata)).collect(Collectors.toList());
            return list;
        }
    }

    private native List<FragmentMetadata> getFragmentsNative();

    /*
     * Exception decompiling
     */
    public Schema getSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private native void importFfiSchema(long var1);

    public List<String> listIndexes() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            Preconditions.checkArgument((this.nativeDatasetHandle != 0L ? 1 : 0) != 0, (Object)"Dataset is closed");
            List<String> list = this.nativeListIndexes();
            return list;
        }
    }

    private native List<String> nativeListIndexes();

    @Override
    public void close() {
        try (LockManager.WriteLock writeLock = this.lockManager.acquireWriteLock();){
            if (this.nativeDatasetHandle != 0L) {
                this.releaseNativeDataset(this.nativeDatasetHandle);
                this.nativeDatasetHandle = 0L;
            }
            if (this.selfManagedAllocator) {
                this.allocator.close();
            }
        }
    }

    private native void releaseNativeDataset(long var1);

    public boolean closed() {
        try (LockManager.ReadLock readLock = this.lockManager.acquireReadLock();){
            boolean bl = this.nativeDatasetHandle == 0L;
            return bl;
        }
    }

    public Fragment getFragment(int fragmentId) {
        FragmentMetadata metadata = this.getFragmentNative(fragmentId);
        return new Fragment(this, metadata);
    }

    private native FragmentMetadata getFragmentNative(int var1);

    static {
        JniLoader.ensureLoaded();
    }
}

