/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.ipc;

import com.lancedb.lance.index.DistanceType;
import java.util.Optional;
import org.apache.arrow.util.Preconditions;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Query {
    private final String column;
    private final float[] key;
    private final int k;
    private final int nprobes;
    private final Optional<Integer> ef;
    private final Optional<Integer> refineFactor;
    private final DistanceType distanceType;
    private final boolean useIndex;

    private Query(Builder builder) {
        this.column = (String)Preconditions.checkNotNull((Object)builder.column, (Object)"Columns must be set");
        Preconditions.checkArgument((!builder.column.isEmpty() ? 1 : 0) != 0, (Object)"Column must not be empty");
        this.key = (float[])Preconditions.checkNotNull((Object)builder.key, (Object)"Key must be set");
        Preconditions.checkArgument((builder.k > 0 ? 1 : 0) != 0, (Object)"K must be greater than 0");
        Preconditions.checkArgument((builder.nprobes > 0 ? 1 : 0) != 0, (Object)"Nprobes must be greater than 0");
        this.k = builder.k;
        this.nprobes = builder.nprobes;
        this.ef = builder.ef;
        this.refineFactor = builder.refineFactor;
        this.distanceType = (DistanceType)((Object)Preconditions.checkNotNull((Object)((Object)builder.distanceType), (Object)"Metric type must be set"));
        this.useIndex = builder.useIndex;
    }

    public String getColumn() {
        return this.column;
    }

    public float[] getKey() {
        return this.key;
    }

    public int getK() {
        return this.k;
    }

    public int getNprobes() {
        return this.nprobes;
    }

    public Optional<Integer> getEf() {
        return this.ef;
    }

    public Optional<Integer> getRefineFactor() {
        return this.refineFactor;
    }

    public String getDistanceType() {
        return this.distanceType.toString();
    }

    public boolean isUseIndex() {
        return this.useIndex;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("column", (Object)this.column).append("key", this.key).append("k", this.k).append("nprobes", this.nprobes).append("ef", this.ef.orElse(null)).append("refineFactor", this.refineFactor.orElse(null)).append("distanceType", (Object)this.distanceType).append("useIndex", this.useIndex).toString();
    }

    public static class Builder {
        private String column;
        private float[] key;
        private int k = 10;
        private int nprobes = 1;
        private Optional<Integer> ef = Optional.empty();
        private Optional<Integer> refineFactor = Optional.empty();
        private DistanceType distanceType = DistanceType.L2;
        private boolean useIndex = true;

        public Builder setColumn(String column) {
            this.column = column;
            return this;
        }

        public Builder setKey(float[] key) {
            this.key = key;
            return this;
        }

        public Builder setK(int k) {
            this.k = k;
            return this;
        }

        public Builder setNprobes(int nprobes) {
            this.nprobes = nprobes;
            return this;
        }

        public Builder setEf(int ef) {
            this.ef = Optional.of(ef);
            return this;
        }

        public Builder setRefineFactor(int refineFactor) {
            this.refineFactor = Optional.of(refineFactor);
            return this;
        }

        public Builder setDistanceType(DistanceType distanceType) {
            this.distanceType = distanceType;
            return this;
        }

        public Builder setUseIndex(boolean useIndex) {
            this.useIndex = useIndex;
            return this;
        }

        public Query build() {
            return new Query(this);
        }
    }
}

