/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.fragment.DataFile;
import com.lancedb.lance.fragment.DeletionFile;
import com.lancedb.lance.fragment.RowIdMeta;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FragmentMetadata
implements Serializable {
    private static final long serialVersionUID = -5886811251944130460L;
    private int id;
    private List<DataFile> files;
    private long physicalRows;
    private DeletionFile deletionFile;
    private RowIdMeta rowIdMeta;

    public FragmentMetadata(int id, List<DataFile> files, Long physicalRows, DeletionFile deletionFile, RowIdMeta rowIdMeta) {
        this.id = id;
        this.files = files;
        this.physicalRows = physicalRows;
        this.deletionFile = deletionFile;
        this.rowIdMeta = rowIdMeta;
    }

    public int getId() {
        return this.id;
    }

    public List<DataFile> getFiles() {
        return this.files;
    }

    public long getPhysicalRows() {
        return this.physicalRows;
    }

    public DeletionFile getDeletionFile() {
        return this.deletionFile;
    }

    public long getNumDeletions() {
        if (this.deletionFile == null) {
            return 0L;
        }
        Long deleted = this.deletionFile.getNumDeletedRows();
        if (deleted == null) {
            return 0L;
        }
        return deleted;
    }

    public long getNumRows() {
        return this.getPhysicalRows() - this.getNumDeletions();
    }

    public RowIdMeta getRowIdMeta() {
        return this.rowIdMeta;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", this.id).append("physicalRows", this.physicalRows).append("files", this.files).append("deletionFile", (Object)this.deletionFile).append("rowIdMeta", (Object)this.rowIdMeta).toString();
    }
}

