/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class ReadOptions {
    private final Optional<Integer> version;
    private final Optional<Integer> blockSize;
    private final long indexCacheSizeBytes;
    private final long metadataCacheSizeBytes;
    private final Optional<ByteBuffer> serializedManifest;
    private final Map<String, String> storageOptions;

    private ReadOptions(Builder builder) {
        this.version = builder.version;
        this.blockSize = builder.blockSize;
        this.indexCacheSizeBytes = builder.indexCacheSizeBytes;
        this.metadataCacheSizeBytes = builder.metadataCacheSizeBytes;
        this.storageOptions = builder.storageOptions;
        this.serializedManifest = builder.serializedManifest;
    }

    public Optional<Integer> getVersion() {
        return this.version;
    }

    public Optional<Integer> getBlockSize() {
        return this.blockSize;
    }

    public long getIndexCacheSizeBytes() {
        return this.indexCacheSizeBytes;
    }

    public long getMetadataCacheSizeBytes() {
        return this.metadataCacheSizeBytes;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public Optional<ByteBuffer> getSerializedManifest() {
        return this.serializedManifest;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("version", this.version.orElse(null)).add("blockSize", this.blockSize.orElse(null)).add("indexCacheSizeBytes", this.indexCacheSizeBytes).add("metadataCacheSizeBytes", this.metadataCacheSizeBytes).add("storageOptions", this.storageOptions).add("serializedManifest", this.serializedManifest.map(buf -> "ByteBuffer[" + buf.remaining() + " bytes]").orElse(null)).toString();
    }

    public static class Builder {
        private Optional<Integer> version = Optional.empty();
        private Optional<Integer> blockSize = Optional.empty();
        private long indexCacheSizeBytes = Integer.MIN_VALUE;
        private long metadataCacheSizeBytes = 0x40000000L;
        private Map<String, String> storageOptions = new HashMap<String, String>();
        private Optional<ByteBuffer> serializedManifest = Optional.empty();

        public Builder setVersion(int version) {
            this.version = Optional.of(version);
            return this;
        }

        public Builder setBlockSize(int blockSize) {
            this.blockSize = Optional.of(blockSize);
            return this;
        }

        public Builder setIndexCacheSizeBytes(long indexCacheSizeBytes) {
            this.indexCacheSizeBytes = indexCacheSizeBytes;
            return this;
        }

        @Deprecated
        public Builder setIndexCacheSize(int indexCacheSize) {
            long assumedEntrySize = 0x1400000L;
            this.indexCacheSizeBytes = (long)indexCacheSize * assumedEntrySize;
            return this;
        }

        public Builder setMetadataCacheSizeBytes(long metadataCacheSizeBytes) {
            this.metadataCacheSizeBytes = metadataCacheSizeBytes;
            return this;
        }

        @Deprecated
        public Builder setMetadataCacheSize(int metadataCacheSize) {
            long assumedEntrySize = 0x400000L;
            this.metadataCacheSizeBytes = (long)metadataCacheSize * assumedEntrySize;
            return this;
        }

        public Builder setStorageOptions(Map<String, String> storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public Builder setSerializedManifest(ByteBuffer serializedManifest) {
            this.serializedManifest = Optional.of(serializedManifest);
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

