/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class WriteParams {
    private final Optional<Integer> maxRowsPerFile;
    private final Optional<Integer> maxRowsPerGroup;
    private final Optional<Long> maxBytesPerFile;
    private final Optional<WriteMode> mode;
    private final Optional<Boolean> enableStableRowIds;
    private Map<String, String> storageOptions = new HashMap<String, String>();

    private WriteParams(Optional<Integer> maxRowsPerFile, Optional<Integer> maxRowsPerGroup, Optional<Long> maxBytesPerFile, Optional<WriteMode> mode, Optional<Boolean> enableStableRowIds, Map<String, String> storageOptions) {
        this.maxRowsPerFile = maxRowsPerFile;
        this.maxRowsPerGroup = maxRowsPerGroup;
        this.maxBytesPerFile = maxBytesPerFile;
        this.mode = mode;
        this.enableStableRowIds = enableStableRowIds;
        this.storageOptions = storageOptions;
    }

    public Optional<Integer> getMaxRowsPerFile() {
        return this.maxRowsPerFile;
    }

    public Optional<Integer> getMaxRowsPerGroup() {
        return this.maxRowsPerGroup;
    }

    public Optional<Long> getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    public Optional<String> getMode() {
        return this.mode.map(Enum::name);
    }

    public Optional<Boolean> getEnableStableRowIds() {
        return this.enableStableRowIds;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("maxRowsPerFile", this.maxRowsPerFile.orElse(null)).add("maxRowsPerGroup", this.maxRowsPerGroup.orElse(null)).add("maxBytesPerFile", this.maxBytesPerFile.orElse(null)).add("mode", this.mode.orElse(null)).toString();
    }

    public static class Builder {
        private Optional<Integer> maxRowsPerFile = Optional.empty();
        private Optional<Integer> maxRowsPerGroup = Optional.empty();
        private Optional<Long> maxBytesPerFile = Optional.empty();
        private Optional<WriteMode> mode = Optional.empty();
        private Optional<Boolean> enableStableRowIds = Optional.empty();
        private Map<String, String> storageOptions = new HashMap<String, String>();

        public Builder withMaxRowsPerFile(int maxRowsPerFile) {
            this.maxRowsPerFile = Optional.of(maxRowsPerFile);
            return this;
        }

        public Builder withMaxRowsPerGroup(int maxRowsPerGroup) {
            this.maxRowsPerGroup = Optional.of(maxRowsPerGroup);
            return this;
        }

        public Builder withMaxBytesPerFile(long maxBytesPerFile) {
            this.maxBytesPerFile = Optional.of(maxBytesPerFile);
            return this;
        }

        public Builder withMode(WriteMode mode) {
            this.mode = Optional.of(mode);
            return this;
        }

        public Builder withStorageOptions(Map<String, String> storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public Builder withEnableStableRowIds(boolean enableStableRowIds) {
            this.enableStableRowIds = Optional.of(enableStableRowIds);
            return this;
        }

        public WriteParams build() {
            return new WriteParams(this.maxRowsPerFile, this.maxRowsPerGroup, this.maxBytesPerFile, this.mode, this.enableStableRowIds, this.storageOptions);
        }
    }

    public static enum WriteMode {
        CREATE,
        APPEND,
        OVERWRITE;

    }
}

