/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.compaction;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.io.Serializable;
import java.util.Optional;

public class CompactionOptions
implements Serializable {
    private final Optional<Long> targetRowsPerFragment;
    private final Optional<Long> maxRowsPerGroup;
    private final Optional<Long> maxBytesPerFile;
    private final Optional<Boolean> materializeDeletions;
    private final Optional<Float> materializeDeletionsThreshold;
    private final Optional<Long> numThreads;
    private final Optional<Long> batchSize;
    private final Optional<Boolean> deferIndexRemap;

    private CompactionOptions(Optional<Long> targetRowsPerFragment, Optional<Long> maxRowsPerGroup, Optional<Long> maxBytesPerFile, Optional<Boolean> materializeDeletions, Optional<Float> materializeDeletionsThreshold, Optional<Long> numThreads, Optional<Long> batchSize, Optional<Boolean> deferIndexRemap) {
        this.targetRowsPerFragment = targetRowsPerFragment;
        this.maxRowsPerGroup = maxRowsPerGroup;
        this.maxBytesPerFile = maxBytesPerFile;
        this.materializeDeletions = materializeDeletions;
        this.materializeDeletionsThreshold = materializeDeletionsThreshold;
        this.numThreads = numThreads;
        this.batchSize = batchSize;
        this.deferIndexRemap = deferIndexRemap;
    }

    public Optional<Boolean> getDeferIndexRemap() {
        return this.deferIndexRemap;
    }

    public Optional<Boolean> getMaterializeDeletions() {
        return this.materializeDeletions;
    }

    public Optional<Float> getMaterializeDeletionsThreshold() {
        return this.materializeDeletionsThreshold;
    }

    public Optional<Long> getBatchSize() {
        return this.batchSize;
    }

    public Optional<Long> getMaxBytesPerFile() {
        return this.maxBytesPerFile;
    }

    public Optional<Long> getMaxRowsPerGroup() {
        return this.maxRowsPerGroup;
    }

    public Optional<Long> getNumThreads() {
        return this.numThreads;
    }

    public Optional<Long> getTargetRowsPerFragment() {
        return this.targetRowsPerFragment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("targetRowsPerFragment", this.targetRowsPerFragment.orElse(null)).add("maxRowsPerGroup", this.maxRowsPerGroup.orElse(null)).add("maxBytesPerFile", this.maxBytesPerFile.orElse(null)).add("materializeDeletions", this.materializeDeletions.orElse(null)).add("materializeDeletionsThreshold", this.materializeDeletionsThreshold.orElse(null)).add("numThreads", this.numThreads.orElse(null)).add("batchSize", this.batchSize.orElse(null)).add("deferIndexRemap", this.deferIndexRemap.orElse(null)).toString();
    }

    public static class Builder {
        private Optional<Long> targetRowsPerFragment = Optional.empty();
        private Optional<Long> maxRowsPerGroup = Optional.empty();
        private Optional<Long> maxBytesPerFile = Optional.empty();
        private Optional<Boolean> materializeDeletions = Optional.empty();
        private Optional<Float> materializeDeletionsThreshold = Optional.empty();
        private Optional<Long> numThreads = Optional.empty();
        private Optional<Long> batchSize = Optional.empty();
        private Optional<Boolean> deferIndexRemap = Optional.empty();

        private Builder() {
        }

        public Builder withTargetRowsPerFragment(long targetRowsPerFragment) {
            this.targetRowsPerFragment = Optional.of(targetRowsPerFragment);
            return this;
        }

        public Builder withMaxRowsPerGroup(long maxRowsPerGroup) {
            this.maxRowsPerGroup = Optional.of(maxRowsPerGroup);
            return this;
        }

        public Builder withMaxBytesPerFile(long maxBytesPerFile) {
            this.maxBytesPerFile = Optional.of(maxBytesPerFile);
            return this;
        }

        public Builder withMaterializeDeletions(boolean materializeDeletions) {
            this.materializeDeletions = Optional.of(materializeDeletions);
            return this;
        }

        public Builder withMaterializeDeletionsThreshold(float materializeDeletionsThreshold) {
            this.materializeDeletionsThreshold = Optional.of(Float.valueOf(materializeDeletionsThreshold));
            return this;
        }

        public Builder withNumThreads(long numThreads) {
            this.numThreads = Optional.of(numThreads);
            return this;
        }

        public Builder withBatchSize(long batchSize) {
            this.batchSize = Optional.of(batchSize);
            return this;
        }

        public Builder withDeferIndexRemap(boolean deferIndexRemap) {
            this.deferIndexRemap = Optional.of(deferIndexRemap);
            return this;
        }

        public CompactionOptions build() {
            return new CompactionOptions(this.targetRowsPerFragment, this.maxRowsPerGroup, this.maxBytesPerFile, this.materializeDeletions, this.materializeDeletionsThreshold, this.numThreads, this.batchSize, this.deferIndexRemap);
        }
    }
}

