/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.cleanup;

import java.util.Optional;

public class CleanupPolicy {
    private final Optional<Long> beforeTimestampMillis;
    private final Optional<Long> beforeVersion;
    private final Optional<Boolean> deleteUnverified;
    private final Optional<Boolean> errorIfTaggedOldVersions;

    private CleanupPolicy(Optional<Long> beforeTimestampMillis, Optional<Long> beforeVersion, Optional<Boolean> deleteUnverified, Optional<Boolean> errorIfTaggedOldVersions) {
        this.beforeTimestampMillis = beforeTimestampMillis;
        this.beforeVersion = beforeVersion;
        this.deleteUnverified = deleteUnverified;
        this.errorIfTaggedOldVersions = errorIfTaggedOldVersions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Long> getBeforeTimestampMillis() {
        return this.beforeTimestampMillis;
    }

    public Optional<Long> getBeforeVersion() {
        return this.beforeVersion;
    }

    public Optional<Boolean> getDeleteUnverified() {
        return this.deleteUnverified;
    }

    public Optional<Boolean> getErrorIfTaggedOldVersions() {
        return this.errorIfTaggedOldVersions;
    }

    public static class Builder {
        private Optional<Long> beforeTimestampMillis = Optional.empty();
        private Optional<Long> beforeVersion = Optional.empty();
        private Optional<Boolean> deleteUnverified = Optional.empty();
        private Optional<Boolean> errorIfTaggedOldVersions = Optional.empty();

        private Builder() {
        }

        public Builder withBeforeTimestampMillis(long beforeTimestampMillis) {
            this.beforeTimestampMillis = Optional.of(beforeTimestampMillis);
            return this;
        }

        public Builder withBeforeVersion(long beforeVersion) {
            this.beforeVersion = Optional.of(beforeVersion);
            return this;
        }

        public Builder withDeleteUnverified(boolean deleteUnverified) {
            this.deleteUnverified = Optional.of(deleteUnverified);
            return this;
        }

        public Builder withErrorIfTaggedOldVersions(boolean errorIfTaggedOldVersions) {
            this.errorIfTaggedOldVersions = Optional.of(errorIfTaggedOldVersions);
            return this;
        }

        public CleanupPolicy build() {
            return new CleanupPolicy(this.beforeTimestampMillis, this.beforeVersion, this.deleteUnverified, this.errorIfTaggedOldVersions);
        }
    }
}

