/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index;

import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class Index {
    private final UUID uuid;
    private final List<Integer> fields;
    private final String name;
    private final long datasetVersion;
    private final List<Integer> fragments;
    private final byte[] indexDetails;
    private final int indexVersion;
    private final Instant createdAt;
    private final Integer baseId;

    private Index(UUID uuid, List<Integer> fields, String name, long datasetVersion, List<Integer> fragments, byte[] indexDetails, int indexVersion, Instant createdAt, Integer baseId) {
        this.uuid = uuid;
        this.fields = fields;
        this.name = name;
        this.datasetVersion = datasetVersion;
        this.fragments = fragments;
        this.indexDetails = indexDetails;
        this.indexVersion = indexVersion;
        this.createdAt = createdAt;
        this.baseId = baseId;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public List<Integer> fields() {
        return this.fields;
    }

    public String name() {
        return this.name;
    }

    public long datasetVersion() {
        return this.datasetVersion;
    }

    public Optional<List<Integer>> fragments() {
        return Optional.ofNullable(this.fragments);
    }

    public Optional<byte[]> indexDetails() {
        return Optional.ofNullable(this.indexDetails);
    }

    public Optional<Integer> baseId() {
        return Optional.ofNullable(this.baseId);
    }

    public int indexVersion() {
        return this.indexVersion;
    }

    public Optional<Instant> createdAt() {
        return Optional.ofNullable(this.createdAt);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Index index = (Index)o;
        return this.datasetVersion == index.datasetVersion && this.indexVersion == index.indexVersion && Objects.equals(this.uuid, index.uuid) && Objects.equals(this.fields, index.fields) && Objects.equals(this.name, index.name) && Objects.equals(this.fragments, index.fragments) && Arrays.equals(this.indexDetails, index.indexDetails) && Objects.equals(this.createdAt, index.createdAt) && Objects.equals(this.baseId, index.baseId);
    }

    public int hashCode() {
        int result = Objects.hash(this.uuid, this.fields, this.name, this.datasetVersion, this.indexVersion, this.createdAt, this.baseId, this.fragments);
        result = 31 * result + Arrays.hashCode(this.indexDetails);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("uuid", this.uuid).add("fields", this.fields).add("name", this.name).add("datasetVersion", this.datasetVersion).add("indexVersion", this.indexVersion).add("createdAt", this.createdAt).add("baseId", this.baseId).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private UUID uuid;
        private List<Integer> fields;
        private String name;
        private long datasetVersion;
        private List<Integer> fragments;
        private byte[] indexDetails;
        private int indexVersion;
        private Instant createdAt;
        private Integer baseId;

        private Builder() {
        }

        public Builder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder fields(List<Integer> fields) {
            this.fields = fields;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder datasetVersion(long datasetVersion) {
            this.datasetVersion = datasetVersion;
            return this;
        }

        public Builder fragments(List<Integer> fragments) {
            this.fragments = fragments;
            return this;
        }

        public Builder indexDetails(byte[] indexDetails) {
            this.indexDetails = indexDetails;
            return this;
        }

        public Builder indexVersion(int indexVersion) {
            this.indexVersion = indexVersion;
            return this;
        }

        public Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder baseId(Integer baseId) {
            this.baseId = baseId;
            return this;
        }

        public Index build() {
            return new Index(this.uuid, this.fields, this.name, this.datasetVersion, this.fragments, this.indexDetails, this.indexVersion, this.createdAt, this.baseId);
        }
    }
}

