/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.index;

import com.lancedb.lance.index.IndexParams;
import com.lancedb.lance.index.IndexType;
import java.util.List;
import java.util.Optional;
import org.apache.arrow.util.Preconditions;

public class IndexOptions {
    private final boolean replace;
    private final boolean train;
    private final List<Integer> fragmentIds;
    private final String indexUUID;
    private final String indexName;
    private final List<String> columns;
    private final IndexType indexType;
    private final IndexParams indexParams;

    private IndexOptions(String indexName, List<String> columns, IndexType indexType, IndexParams indexParams, boolean replace, boolean train, List<Integer> fragmentIds, String indexUUID) {
        this.replace = replace;
        this.train = train;
        this.fragmentIds = fragmentIds;
        this.indexUUID = indexUUID;
        this.indexName = indexName;
        this.columns = columns;
        this.indexType = indexType;
        this.indexParams = indexParams;
    }

    public Optional<String> getIndexUUID() {
        return Optional.ofNullable(this.indexUUID);
    }

    public Optional<List<Integer>> getFragmentIds() {
        return Optional.ofNullable(this.fragmentIds);
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isTrain() {
        return this.train;
    }

    public Optional<String> getIndexName() {
        return Optional.ofNullable(this.indexName);
    }

    public IndexParams getIndexParams() {
        return this.indexParams;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public static Builder builder(List<String> columns, IndexType indexType, IndexParams indexParams) {
        return new Builder(columns, indexType, indexParams);
    }

    public static class Builder {
        private boolean replace = false;
        private boolean train = true;
        private List<Integer> fragmentIds = null;
        private String indexUUID = null;
        private String indexName = null;
        private final List<String> columns;
        private final IndexType indexType;
        private final IndexParams indexParams;

        private Builder(List<String> columns, IndexType indexType, IndexParams indexParams) {
            this.columns = (List)Preconditions.checkNotNull(columns);
            this.indexType = (IndexType)((Object)Preconditions.checkNotNull((Object)((Object)indexType)));
            this.indexParams = (IndexParams)Preconditions.checkNotNull((Object)indexParams);
        }

        public Builder replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public Builder train(boolean train) {
            this.train = train;
            return this;
        }

        public Builder withFragmentIds(List<Integer> fragmentIds) {
            this.fragmentIds = fragmentIds;
            return this;
        }

        public Builder withIndexUUID(String indexUUID) {
            this.indexUUID = indexUUID;
            return this;
        }

        public Builder withIndexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public IndexOptions build() {
            return new IndexOptions(this.indexName, this.columns, this.indexType, this.indexParams, this.replace, this.train, this.fragmentIds, this.indexUUID);
        }
    }
}

