/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.index.Index;
import com.lancedb.lance.operation.Operation;
import com.lancedb.lance.shaded.guava.base.MoreObjects;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class CreateIndex
implements Operation {
    private final List<Index> newIndices;
    private final List<Index> removedIndices;

    private CreateIndex(List<Index> newIndices, List<Index> removedIndices) {
        this.newIndices = newIndices;
        this.removedIndices = removedIndices;
    }

    public List<Index> getNewIndices() {
        return this.newIndices;
    }

    public List<Index> getRemovedIndices() {
        return this.removedIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateIndex that = (CreateIndex)o;
        return Objects.equals(this.newIndices, that.newIndices) && Objects.equals(this.removedIndices, that.removedIndices);
    }

    public int hashCode() {
        return Objects.hash(this.newIndices, this.removedIndices);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("newIndices", this.newIndices).add("removedIndices", this.removedIndices).toString();
    }

    @Override
    public String name() {
        return "CreateIndex";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Index> newIndices = Collections.emptyList();
        private List<Index> removedIndices = Collections.emptyList();

        private Builder() {
        }

        public Builder withNewIndices(List<Index> newIndices) {
            this.newIndices = newIndices;
            return this;
        }

        public Builder withRemovedIndices(List<Index> removedIndices) {
            this.removedIndices = removedIndices;
            return this;
        }

        public CreateIndex build() {
            return new CreateIndex(this.newIndices, this.removedIndices);
        }
    }
}

