/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.client.apache.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.lancedb.lance.namespace.client.apache.ApiClient;
import com.lancedb.lance.namespace.client.apache.ApiException;
import com.lancedb.lance.namespace.client.apache.BaseApi;
import com.lancedb.lance.namespace.client.apache.Configuration;
import com.lancedb.lance.namespace.client.apache.Pair;
import com.lancedb.lance.namespace.model.CountTableRowsRequest;
import com.lancedb.lance.namespace.model.CreateTableIndexRequest;
import com.lancedb.lance.namespace.model.CreateTableIndexResponse;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DeleteFromTableRequest;
import com.lancedb.lance.namespace.model.DeleteFromTableResponse;
import com.lancedb.lance.namespace.model.DeregisterTableRequest;
import com.lancedb.lance.namespace.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.model.DescribeTableIndexStatsRequest;
import com.lancedb.lance.namespace.model.DescribeTableIndexStatsResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.InsertIntoTableResponse;
import com.lancedb.lance.namespace.model.ListTableIndicesRequest;
import com.lancedb.lance.namespace.model.ListTableIndicesResponse;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.MergeInsertIntoTableResponse;
import com.lancedb.lance.namespace.model.QueryTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableResponse;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.model.UpdateTableRequest;
import com.lancedb.lance.namespace.model.UpdateTableResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class TableApi
extends BaseApi {
    public TableApi() {
        super(Configuration.getDefaultApiClient());
    }

    public TableApi(ApiClient apiClient) {
        super(apiClient);
    }

    public Long countTableRows(String id, CountTableRowsRequest countTableRowsRequest, String delimiter) throws ApiException {
        return this.countTableRows(id, countTableRowsRequest, delimiter, Collections.emptyMap());
    }

    public Long countTableRows(String id, CountTableRowsRequest countTableRowsRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        CountTableRowsRequest localVarPostBody = countTableRowsRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling countTableRows");
        }
        if (countTableRowsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'countTableRowsRequest' when calling countTableRows");
        }
        String localVarPath = "/v1/table/{id}/count_rows".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<Long> localVarReturnType = new TypeReference<Long>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateTableResponse createTable(String id, byte[] body, String delimiter, String xLanceTableLocation, String xLanceTableProperties) throws ApiException {
        return this.createTable(id, body, delimiter, xLanceTableLocation, xLanceTableProperties, Collections.emptyMap());
    }

    public CreateTableResponse createTable(String id, byte[] body, String delimiter, String xLanceTableLocation, String xLanceTableProperties, Map<String, String> additionalHeaders) throws ApiException {
        byte[] localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createTable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling createTable");
        }
        String localVarPath = "/v1/table/{id}/create".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        if (xLanceTableLocation != null) {
            localVarHeaderParams.put("x-lance-table-location", this.apiClient.parameterToString(xLanceTableLocation));
        }
        if (xLanceTableProperties != null) {
            localVarHeaderParams.put("x-lance-table-properties", this.apiClient.parameterToString(xLanceTableProperties));
        }
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.apache.arrow.stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<CreateTableResponse> localVarReturnType = new TypeReference<CreateTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CreateTableIndexResponse createTableIndex(String id, CreateTableIndexRequest createTableIndexRequest, String delimiter) throws ApiException {
        return this.createTableIndex(id, createTableIndexRequest, delimiter, Collections.emptyMap());
    }

    public CreateTableIndexResponse createTableIndex(String id, CreateTableIndexRequest createTableIndexRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        CreateTableIndexRequest localVarPostBody = createTableIndexRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling createTableIndex");
        }
        if (createTableIndexRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'createTableIndexRequest' when calling createTableIndex");
        }
        String localVarPath = "/v1/table/{id}/create_index".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<CreateTableIndexResponse> localVarReturnType = new TypeReference<CreateTableIndexResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeleteFromTableResponse deleteFromTable(String id, DeleteFromTableRequest deleteFromTableRequest, String delimiter) throws ApiException {
        return this.deleteFromTable(id, deleteFromTableRequest, delimiter, Collections.emptyMap());
    }

    public DeleteFromTableResponse deleteFromTable(String id, DeleteFromTableRequest deleteFromTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DeleteFromTableRequest localVarPostBody = deleteFromTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deleteFromTable");
        }
        if (deleteFromTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deleteFromTableRequest' when calling deleteFromTable");
        }
        String localVarPath = "/v1/table/{id}/delete".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DeleteFromTableResponse> localVarReturnType = new TypeReference<DeleteFromTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DeregisterTableResponse deregisterTable(String id, DeregisterTableRequest deregisterTableRequest, String delimiter) throws ApiException {
        return this.deregisterTable(id, deregisterTableRequest, delimiter, Collections.emptyMap());
    }

    public DeregisterTableResponse deregisterTable(String id, DeregisterTableRequest deregisterTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DeregisterTableRequest localVarPostBody = deregisterTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling deregisterTable");
        }
        if (deregisterTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'deregisterTableRequest' when calling deregisterTable");
        }
        String localVarPath = "/v1/table/{id}/deregister".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DeregisterTableResponse> localVarReturnType = new TypeReference<DeregisterTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DescribeTableResponse describeTable(String id, DescribeTableRequest describeTableRequest, String delimiter) throws ApiException {
        return this.describeTable(id, describeTableRequest, delimiter, Collections.emptyMap());
    }

    public DescribeTableResponse describeTable(String id, DescribeTableRequest describeTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DescribeTableRequest localVarPostBody = describeTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling describeTable");
        }
        if (describeTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'describeTableRequest' when calling describeTable");
        }
        String localVarPath = "/v1/table/{id}/describe".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DescribeTableResponse> localVarReturnType = new TypeReference<DescribeTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DescribeTableIndexStatsResponse describeTableIndexStats(String id, String indexName, DescribeTableIndexStatsRequest describeTableIndexStatsRequest, String delimiter) throws ApiException {
        return this.describeTableIndexStats(id, indexName, describeTableIndexStatsRequest, delimiter, Collections.emptyMap());
    }

    public DescribeTableIndexStatsResponse describeTableIndexStats(String id, String indexName, DescribeTableIndexStatsRequest describeTableIndexStatsRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DescribeTableIndexStatsRequest localVarPostBody = describeTableIndexStatsRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling describeTableIndexStats");
        }
        if (indexName == null) {
            throw new ApiException(400, "Missing the required parameter 'indexName' when calling describeTableIndexStats");
        }
        if (describeTableIndexStatsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'describeTableIndexStatsRequest' when calling describeTableIndexStats");
        }
        String localVarPath = "/v1/table/{id}/index/{index_name}/stats".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id))).replaceAll("\\{index_name\\}", this.apiClient.escapeString(this.apiClient.parameterToString(indexName)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DescribeTableIndexStatsResponse> localVarReturnType = new TypeReference<DescribeTableIndexStatsResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public DropTableResponse dropTable(String id, DropTableRequest dropTableRequest, String delimiter) throws ApiException {
        return this.dropTable(id, dropTableRequest, delimiter, Collections.emptyMap());
    }

    public DropTableResponse dropTable(String id, DropTableRequest dropTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        DropTableRequest localVarPostBody = dropTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling dropTable");
        }
        if (dropTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'dropTableRequest' when calling dropTable");
        }
        String localVarPath = "/v1/table/{id}/drop".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<DropTableResponse> localVarReturnType = new TypeReference<DropTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public InsertIntoTableResponse insertIntoTable(String id, byte[] body, String delimiter, String mode) throws ApiException {
        return this.insertIntoTable(id, body, delimiter, mode, Collections.emptyMap());
    }

    public InsertIntoTableResponse insertIntoTable(String id, byte[] body, String delimiter, String mode, Map<String, String> additionalHeaders) throws ApiException {
        byte[] localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling insertIntoTable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling insertIntoTable");
        }
        String localVarPath = "/v1/table/{id}/insert".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("mode", mode));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.apache.arrow.stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<InsertIntoTableResponse> localVarReturnType = new TypeReference<InsertIntoTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListTableIndicesResponse listTableIndices(String id, ListTableIndicesRequest listTableIndicesRequest, String delimiter) throws ApiException {
        return this.listTableIndices(id, listTableIndicesRequest, delimiter, Collections.emptyMap());
    }

    public ListTableIndicesResponse listTableIndices(String id, ListTableIndicesRequest listTableIndicesRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        ListTableIndicesRequest localVarPostBody = listTableIndicesRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listTableIndices");
        }
        if (listTableIndicesRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'listTableIndicesRequest' when calling listTableIndices");
        }
        String localVarPath = "/v1/table/{id}/index/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ListTableIndicesResponse> localVarReturnType = new TypeReference<ListTableIndicesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public ListTablesResponse listTables(String id, String delimiter, String pageToken, Integer limit) throws ApiException {
        return this.listTables(id, delimiter, pageToken, limit, Collections.emptyMap());
    }

    public ListTablesResponse listTables(String id, String delimiter, String pageToken, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling listTables");
        }
        String localVarPath = "/v1/namespace/{id}/table/list".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page_token", pageToken));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<ListTablesResponse> localVarReturnType = new TypeReference<ListTablesResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public MergeInsertIntoTableResponse mergeInsertIntoTable(String id, String on, byte[] body, String delimiter, Boolean whenMatchedUpdateAll, String whenMatchedUpdateAllFilt, Boolean whenNotMatchedInsertAll, Boolean whenNotMatchedBySourceDelete, String whenNotMatchedBySourceDeleteFilt) throws ApiException {
        return this.mergeInsertIntoTable(id, on, body, delimiter, whenMatchedUpdateAll, whenMatchedUpdateAllFilt, whenNotMatchedInsertAll, whenNotMatchedBySourceDelete, whenNotMatchedBySourceDeleteFilt, Collections.emptyMap());
    }

    public MergeInsertIntoTableResponse mergeInsertIntoTable(String id, String on, byte[] body, String delimiter, Boolean whenMatchedUpdateAll, String whenMatchedUpdateAllFilt, Boolean whenNotMatchedInsertAll, Boolean whenNotMatchedBySourceDelete, String whenNotMatchedBySourceDeleteFilt, Map<String, String> additionalHeaders) throws ApiException {
        byte[] localVarPostBody = body;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling mergeInsertIntoTable");
        }
        if (on == null) {
            throw new ApiException(400, "Missing the required parameter 'on' when calling mergeInsertIntoTable");
        }
        if (body == null) {
            throw new ApiException(400, "Missing the required parameter 'body' when calling mergeInsertIntoTable");
        }
        String localVarPath = "/v1/table/{id}/merge_insert".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("on", on));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("when_matched_update_all", whenMatchedUpdateAll));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("when_matched_update_all_filt", whenMatchedUpdateAllFilt));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("when_not_matched_insert_all", whenNotMatchedInsertAll));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("when_not_matched_by_source_delete", whenNotMatchedBySourceDelete));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("when_not_matched_by_source_delete_filt", whenNotMatchedBySourceDeleteFilt));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/vnd.apache.arrow.stream"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<MergeInsertIntoTableResponse> localVarReturnType = new TypeReference<MergeInsertIntoTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public byte[] queryTable(String id, QueryTableRequest queryTableRequest, String delimiter) throws ApiException {
        return this.queryTable(id, queryTableRequest, delimiter, Collections.emptyMap());
    }

    public byte[] queryTable(String id, QueryTableRequest queryTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        QueryTableRequest localVarPostBody = queryTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling queryTable");
        }
        if (queryTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'queryTableRequest' when calling queryTable");
        }
        String localVarPath = "/v1/table/{id}/query".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/vnd.apache.arrow.file", "application/vnd.apache.arrow.stream", "application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<byte[]> localVarReturnType = new TypeReference<byte[]>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public RegisterTableResponse registerTable(String id, RegisterTableRequest registerTableRequest, String delimiter) throws ApiException {
        return this.registerTable(id, registerTableRequest, delimiter, Collections.emptyMap());
    }

    public RegisterTableResponse registerTable(String id, RegisterTableRequest registerTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        RegisterTableRequest localVarPostBody = registerTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling registerTable");
        }
        if (registerTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'registerTableRequest' when calling registerTable");
        }
        String localVarPath = "/v1/table/{id}/register".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<RegisterTableResponse> localVarReturnType = new TypeReference<RegisterTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void tableExists(String id, TableExistsRequest tableExistsRequest, String delimiter) throws ApiException {
        this.tableExists(id, tableExistsRequest, delimiter, Collections.emptyMap());
    }

    public void tableExists(String id, TableExistsRequest tableExistsRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        TableExistsRequest localVarPostBody = tableExistsRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling tableExists");
        }
        if (tableExistsRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'tableExistsRequest' when calling tableExists");
        }
        String localVarPath = "/v1/table/{id}/exists".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public UpdateTableResponse updateTable(String id, UpdateTableRequest updateTableRequest, String delimiter) throws ApiException {
        return this.updateTable(id, updateTableRequest, delimiter, Collections.emptyMap());
    }

    public UpdateTableResponse updateTable(String id, UpdateTableRequest updateTableRequest, String delimiter, Map<String, String> additionalHeaders) throws ApiException {
        UpdateTableRequest localVarPostBody = updateTableRequest;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling updateTable");
        }
        if (updateTableRequest == null) {
            throw new ApiException(400, "Missing the required parameter 'updateTableRequest' when calling updateTable");
        }
        String localVarPath = "/v1/table/{id}/update".replaceAll("\\{id\\}", this.apiClient.escapeString(this.apiClient.parameterToString(id)));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("delimiter", delimiter));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        TypeReference<UpdateTableResponse> localVarReturnType = new TypeReference<UpdateTableResponse>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    @Override
    public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
        String localVarPath = url.replace(this.apiClient.getBaseURL(), "");
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.invokeAPI(localVarPath, method, localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), request, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, returnType);
    }
}

