/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.lancedb.lance.namespace.util.CommonUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCommonUtil {
    @Test
    public void testMakeQualified() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommonUtil.makeQualified((String)"./cat"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommonUtil.makeQualified((String)"cat"));
        Assertions.assertThrows(NullPointerException.class, () -> CommonUtil.makeQualified(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommonUtil.makeQualified((String)""));
        Assertions.assertEquals((Object)"s3://bucket/cat", (Object)CommonUtil.makeQualified((String)"s3://bucket/cat"));
        Assertions.assertEquals((Object)"s3:///cat", (Object)CommonUtil.makeQualified((String)"s3:///cat"));
        Assertions.assertEquals((Object)"s3://bucket/cat", (Object)CommonUtil.makeQualified((String)"s3://bucket/cat?param=foo"));
        Assertions.assertEquals((Object)"s3://bucket/cat", (Object)CommonUtil.makeQualified((String)"s3://bucket/cat#frag=0"));
        Assertions.assertEquals((Object)"file:///cat", (Object)CommonUtil.makeQualified((String)"/cat"));
        Assertions.assertEquals((Object)"file:///var/folders/test", (Object)CommonUtil.makeQualified((String)"/var/folders/test"));
    }
}

