/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.google.common.collect.Maps;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.client.apache.ApiException;
import com.lancedb.lance.namespace.model.ErrorResponse;
import java.io.IOException;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestException {
    @Test
    public void testDefaultApiException() {
        ApiException apiError = new ApiException();
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        Assertions.assertFalse((boolean)nsError.getErrorResponse().isPresent());
        Assertions.assertEquals((int)0, (int)nsError.getCode());
    }

    @Test
    public void testApiExceptionFromIOError() {
        ApiException apiError = new ApiException((Throwable)new IOException("connect timeout"));
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        Assertions.assertFalse((boolean)nsError.getErrorResponse().isPresent());
        Assertions.assertEquals((int)0, (int)nsError.getCode());
    }

    @Test
    public void testApiExceptionFromMessage() {
        ApiException apiError = new ApiException("connect timeout");
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        Assertions.assertFalse((boolean)nsError.getErrorResponse().isPresent());
        Assertions.assertEquals((int)0, (int)nsError.getCode());
        Assertions.assertEquals((Object)"connect timeout", (Object)nsError.getMessage());
    }

    @Test
    public void testApiExceptionWithInvalidJsonResponse() {
        String jsonResponse = "{,,}";
        ApiException apiError = new ApiException("message", (Throwable)new IOException("connect timeout"), 123, (Map)Maps.newHashMap(), jsonResponse);
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        Assertions.assertFalse((boolean)nsError.getErrorResponse().isPresent());
        Assertions.assertEquals((int)123, (int)nsError.getCode());
        Assertions.assertEquals((Object)"{,,}", (Object)nsError.getMessage());
    }

    @Test
    public void testApiExceptionWithValidJsonResponse() {
        String jsonResponse = "{\"type\":\"/errors/not-found-error\",\"error\":\"Not found Error\",\"code\":\"404\",\"instance\":\"/v1/namespaces\",\"detail\":\"Namespace not found\"}";
        ApiException apiError = new ApiException("message", (Throwable)new IOException("connect timeout"), 123, (Map)Maps.newHashMap(), jsonResponse);
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        ErrorResponse errorResponse = (ErrorResponse)nsError.getErrorResponse().get();
        Assertions.assertEquals((Object)"Not found Error", (Object)errorResponse.getError());
        Assertions.assertEquals((Object)"/errors/not-found-error", (Object)errorResponse.getType());
        Assertions.assertEquals((int)404, (Integer)errorResponse.getCode());
        Assertions.assertEquals((Object)"/v1/namespaces", (Object)errorResponse.getInstance());
        Assertions.assertEquals((Object)"Namespace not found", (Object)errorResponse.getDetail());
    }

    @Test
    public void testApiExceptionWithUnknownFields() {
        String jsonResponse = "{\"type\":\"/errors/validation-error\",\"error\":\"Validation Error\",\"code\":\"400\",\"instance\":\"/v1/tables\",\"detail\":\"Invalid table name\",\"unknownField\":\"should_be_ignored\",\"futureExtension\":123,\"nestedUnknown\":{\"some\":\"data\"},\"arrayUnknown\":[\"item1\",\"item2\"]}";
        ApiException apiError = new ApiException("message", (Throwable)new IOException("validation error"), 400, (Map)Maps.newHashMap(), jsonResponse);
        LanceNamespaceException nsError = new LanceNamespaceException(apiError);
        ErrorResponse errorResponse = (ErrorResponse)nsError.getErrorResponse().get();
        Assertions.assertEquals((Object)"Validation Error", (Object)errorResponse.getError());
        Assertions.assertEquals((Object)"/errors/validation-error", (Object)errorResponse.getType());
        Assertions.assertEquals((int)400, (Integer)errorResponse.getCode());
        Assertions.assertEquals((Object)"/v1/tables", (Object)errorResponse.getInstance());
        Assertions.assertEquals((Object)"Invalid table name", (Object)errorResponse.getDetail());
    }
}

