/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.lancedb.lance.namespace.model.JsonArrowDataType;
import com.lancedb.lance.namespace.model.JsonArrowField;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamWriter;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;

public class TestHelper {
    public static JsonArrowSchema createTestSchema() {
        JsonArrowSchema schema = new JsonArrowSchema();
        JsonArrowDataType intType = new JsonArrowDataType();
        intType.setType("int32");
        JsonArrowDataType stringType = new JsonArrowDataType();
        stringType.setType("utf8");
        JsonArrowField idField = new JsonArrowField();
        idField.setName("id");
        idField.setType(intType);
        idField.setNullable(Boolean.valueOf(false));
        JsonArrowField nameField = new JsonArrowField();
        nameField.setName("name");
        nameField.setType(stringType);
        nameField.setNullable(Boolean.valueOf(true));
        schema.setFields(Arrays.asList(idField, nameField));
        return schema;
    }

    public static byte[] createTestArrowData(BufferAllocator allocator) throws IOException {
        Schema arrowSchema = new Schema(Arrays.asList(new Field("id", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null), new Field("name", FieldType.nullable((ArrowType)new ArrowType.Utf8()), null)));
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);){
            IntVector idVector = (IntVector)root.getVector("id");
            VarCharVector nameVector = (VarCharVector)root.getVector("name");
            root.setRowCount(3);
            idVector.setSafe(0, 1);
            idVector.setSafe(1, 2);
            idVector.setSafe(2, 3);
            nameVector.setSafe(0, "Alice".getBytes(StandardCharsets.UTF_8));
            nameVector.setSafe(1, "Bob".getBytes(StandardCharsets.UTF_8));
            nameVector.setSafe(2, "Charlie".getBytes(StandardCharsets.UTF_8));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(out));){
                writer.start();
                writer.writeBatch();
                writer.end();
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static byte[] createEmptyArrowData(BufferAllocator allocator) throws IOException {
        Schema arrowSchema = new Schema(Arrays.asList(new Field("id", FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null), new Field("name", FieldType.nullable((ArrowType)new ArrowType.Utf8()), null)));
        try (VectorSchemaRoot root = VectorSchemaRoot.create((Schema)arrowSchema, (BufferAllocator)allocator);){
            root.setRowCount(0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (ArrowStreamWriter writer = new ArrowStreamWriter(root, null, Channels.newChannel(out));){
                writer.start();
                writer.writeBatch();
                writer.end();
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

