/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.google.common.collect.Lists;
import com.lancedb.lance.namespace.ObjectIdentifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestObjectIdentifier {
    @Test
    public void testObjectIdentifier() {
        ArrayList ns = Lists.newArrayList();
        ns.add(null);
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectIdentifier.of((List)ns));
        ns.clear();
        ns.add("");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectIdentifier.of((List)ns));
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a", ""})));
        ObjectIdentifier oid = ObjectIdentifier.of((List)Lists.newArrayList());
        Assertions.assertEquals((int)0, (int)oid.levels());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a", "b"}));
        Assertions.assertEquals((int)2, (int)oid.levels());
        Assertions.assertEquals((Object)"a", (Object)oid.levelAtListPos(0));
        Assertions.assertEquals((Object)"b", (Object)oid.levelAtListPos(1));
        oid = ObjectIdentifier.of((List)Lists.newArrayList());
        Assertions.assertEquals((Object)".", (Object)oid.stringStyleId());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a"}));
        Assertions.assertEquals((Object)"a", (Object)oid.stringStyleId());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a", "b"}));
        Assertions.assertEquals((Object)"a.b", (Object)oid.stringStyleId());
        oid = ObjectIdentifier.of((List)Lists.newArrayList());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((ObjectIdentifier)oid).parent());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a"}));
        Assertions.assertEquals((Object)Lists.newArrayList(), (Object)oid.parent());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a", "b"}));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a"}), (Object)oid.parent());
        oid = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), (Object)oid.parent());
    }
}

