/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.dir;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.dir.DirectoryNamespace;
import com.lancedb.lance.namespace.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.JsonArrowDataType;
import com.lancedb.lance.namespace.model.JsonArrowField;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.util.ArrowIpcUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Field;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDirectoryNamespace {
    private static BufferAllocator allocator;
    private DirectoryNamespace namespace;
    @TempDir
    private Path tempDir;

    @BeforeAll
    public static void setUpAll() {
        allocator = new RootAllocator(Long.MAX_VALUE);
    }

    @AfterAll
    public static void tearDownAll() throws Exception {
        if (allocator != null) {
            allocator.close();
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.namespace = new DirectoryNamespace();
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    private JsonArrowSchema createTestSchema() {
        JsonArrowDataType intType = new JsonArrowDataType();
        intType.setType("int32");
        JsonArrowDataType stringType = new JsonArrowDataType();
        stringType.setType("utf8");
        JsonArrowField idField = new JsonArrowField();
        idField.setName("id");
        idField.setType(intType);
        idField.setNullable(Boolean.valueOf(false));
        JsonArrowField nameField = new JsonArrowField();
        nameField.setName("name");
        nameField.setType(stringType);
        nameField.setNullable(Boolean.valueOf(true));
        ArrayList<JsonArrowField> fields = new ArrayList<JsonArrowField>();
        fields.add(idField);
        fields.add(nameField);
        JsonArrowSchema schema = new JsonArrowSchema();
        schema.setFields(fields);
        return schema;
    }

    private byte[] createTestArrowData() throws IOException {
        JsonArrowSchema schema = this.createTestSchema();
        return ArrowIpcUtil.createEmptyArrowIpcStream((JsonArrowSchema)schema);
    }

    @Test
    public void testInitializeWithAbsolutePath() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
    }

    @Test
    public void testInitializeWithFileUri() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", "file://" + this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
    }

    @Test
    public void testInitializeWithRelativePath() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", "./test-namespace");
        this.namespace.initialize(properties, allocator);
    }

    @Test
    public void testInitializeWithoutRoot() {
        HashMap properties = new HashMap();
        this.namespace.initialize(properties, allocator);
    }

    @Test
    public void testCreateTable() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest request = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        request.setId(tableId);
        CreateTableResponse response = this.namespace.createTable(request, this.createTestArrowData());
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getLocation());
        Assertions.assertTrue((boolean)response.getLocation().contains("test_table"));
        Assertions.assertEquals((Long)1L, (Long)response.getVersion());
        File tableDir = new File(this.tempDir.toFile(), "test_table.lance");
        Assertions.assertTrue((boolean)tableDir.exists());
        Assertions.assertTrue((boolean)tableDir.isDirectory());
        File versionsDir = new File(tableDir, "_versions");
        Assertions.assertTrue((boolean)versionsDir.exists());
        Assertions.assertTrue((boolean)versionsDir.isDirectory());
        try (Dataset dataset = Dataset.open((String)response.getLocation(), (BufferAllocator)allocator);){
            Assertions.assertNotNull((Object)dataset);
            Assertions.assertNotNull((Object)dataset.getSchema());
            Assertions.assertEquals((int)2, (int)dataset.getSchema().getFields().size());
            Assertions.assertEquals((Object)"id", (Object)((Field)dataset.getSchema().getFields().get(0)).getName());
            Assertions.assertEquals((Object)"name", (Object)((Field)dataset.getSchema().getFields().get(1)).getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to verify created dataset", e);
        }
    }

    @Test
    public void testListTables() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest request1 = new CreateTableRequest();
        ArrayList<String> tableId1 = new ArrayList<String>();
        tableId1.add("table1");
        request1.setId(tableId1);
        this.namespace.createTable(request1, this.createTestArrowData());
        CreateTableRequest request2 = new CreateTableRequest();
        ArrayList<String> tableId2 = new ArrayList<String>();
        tableId2.add("table2");
        request2.setId(tableId2);
        this.namespace.createTable(request2, this.createTestArrowData());
        CreateTableRequest request3 = new CreateTableRequest();
        ArrayList<String> tableId3 = new ArrayList<String>();
        tableId3.add("table3");
        request3.setId(tableId3);
        this.namespace.createTable(request3, this.createTestArrowData());
        ListTablesRequest listRequest = new ListTablesRequest();
        ListTablesResponse response = this.namespace.listTables(listRequest);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getTables());
        Assertions.assertEquals((int)3, (int)response.getTables().size());
        Assertions.assertTrue((boolean)response.getTables().contains("table1"));
        Assertions.assertTrue((boolean)response.getTables().contains("table2"));
        Assertions.assertTrue((boolean)response.getTables().contains("table3"));
    }

    @Test
    public void testDropTable() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest createRequest = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        createRequest.setId(tableId);
        this.namespace.createTable(createRequest, this.createTestArrowData());
        File tableDir = new File(this.tempDir.toFile(), "test_table.lance");
        Assertions.assertTrue((boolean)tableDir.exists());
        File versionsDir = new File(tableDir, "_versions");
        Assertions.assertTrue((boolean)versionsDir.exists());
        DropTableRequest dropRequest = new DropTableRequest();
        dropRequest.setId(tableId);
        DropTableResponse response = this.namespace.dropTable(dropRequest);
        Assertions.assertNotNull((Object)response);
        Assertions.assertFalse((boolean)tableDir.exists());
    }

    @Test
    public void testDescribeTable() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest createRequest = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        createRequest.setId(tableId);
        this.namespace.createTable(createRequest, this.createTestArrowData());
        DescribeTableRequest describeRequest = new DescribeTableRequest();
        describeRequest.setId(tableId);
        DescribeTableResponse response = this.namespace.describeTable(describeRequest);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getLocation());
        Assertions.assertTrue((boolean)response.getLocation().contains("test_table"));
        Assertions.assertTrue((boolean)response.getLocation().contains(this.tempDir.toString()));
    }

    @Test
    public void testDescribeNonExistentTable() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        DescribeTableRequest request = new DescribeTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("non_existent_table");
        request.setId(tableId);
        Assertions.assertThrows(Exception.class, () -> this.namespace.describeTable(request));
    }

    @Test
    public void testEmptyListTables() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        ListTablesRequest request = new ListTablesRequest();
        ListTablesResponse response = this.namespace.listTables(request);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getTables());
        Assertions.assertEquals((int)0, (int)response.getTables().size());
    }

    @Test
    public void testNamespaceOperationsNotSupported() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.namespace.createNamespace(new CreateNamespaceRequest()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.namespace.listNamespaces(new ListNamespacesRequest()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.namespace.describeNamespace(new DescribeNamespaceRequest()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.namespace.dropNamespace(new DropNamespaceRequest()));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.namespace.namespaceExists(new NamespaceExistsRequest()));
    }

    @Test
    public void testCreateTableWithInvalidMultiLevelId() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest request = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("namespace1");
        tableId.add("test_table");
        request.setId(tableId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.namespace.createTable(request, this.createTestArrowData()));
    }

    @Test
    public void testListTablesWithRootNamespaceId() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest request = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        request.setId(tableId);
        this.namespace.createTable(request, this.createTestArrowData());
        ListTablesRequest listRequest = new ListTablesRequest();
        listRequest.setId(new ArrayList());
        ListTablesResponse response = this.namespace.listTables(listRequest);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getTables());
        Assertions.assertEquals((int)1, (int)response.getTables().size());
        Assertions.assertTrue((boolean)response.getTables().contains("test_table"));
    }

    @Test
    public void testListTablesWithNonEmptyNamespaceId() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest request = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        request.setId(tableId);
        this.namespace.createTable(request, this.createTestArrowData());
        ListTablesRequest listRequest = new ListTablesRequest();
        ArrayList<String> namespaceId = new ArrayList<String>();
        namespaceId.add("default");
        listRequest.setId(namespaceId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.namespace.listTables(listRequest));
    }

    @Test
    public void testListTablesWithInvalidNamespaceId() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        ListTablesRequest listRequest = new ListTablesRequest();
        ArrayList<String> namespaceId = new ArrayList<String>();
        namespaceId.add("namespace1");
        listRequest.setId(namespaceId);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.namespace.listTables(listRequest));
    }

    @Test
    public void testTableExists() throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateTableRequest createRequest = new CreateTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        createRequest.setId(tableId);
        this.namespace.createTable(createRequest, this.createTestArrowData());
        TableExistsRequest existsRequest = new TableExistsRequest();
        existsRequest.setId(tableId);
        this.namespace.tableExists(existsRequest);
    }

    @Test
    public void testTableExistsNonExistent() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        TableExistsRequest existsRequest = new TableExistsRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("non_existent_table");
        existsRequest.setId(tableId);
        LanceNamespaceException exception = (LanceNamespaceException)Assertions.assertThrows(LanceNamespaceException.class, () -> this.namespace.tableExists(existsRequest));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Table does not exist"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("non_existent_table"));
    }

    @Test
    public void testCreateEmptyTable() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateEmptyTableRequest request = new CreateEmptyTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("empty_table");
        request.setId(tableId);
        CreateEmptyTableResponse response = this.namespace.createEmptyTable(request);
        Assertions.assertNotNull((Object)response);
        Assertions.assertNotNull((Object)response.getLocation());
        Assertions.assertTrue((boolean)response.getLocation().contains("empty_table"));
        File tableDir = new File(this.tempDir.toFile(), "empty_table.lance");
        Assertions.assertTrue((boolean)tableDir.exists());
        Assertions.assertTrue((boolean)tableDir.isDirectory());
        File reservedFile = new File(tableDir, ".lance-reserved");
        Assertions.assertTrue((boolean)reservedFile.exists());
        Assertions.assertTrue((boolean)reservedFile.isFile());
        Assertions.assertEquals((long)0L, (long)reservedFile.length());
        ListTablesRequest listRequest = new ListTablesRequest();
        ListTablesResponse listResponse = this.namespace.listTables(listRequest);
        Assertions.assertNotNull((Object)listResponse);
        Assertions.assertTrue((boolean)listResponse.getTables().contains("empty_table"));
        DescribeTableRequest describeRequest = new DescribeTableRequest();
        describeRequest.setId(tableId);
        DescribeTableResponse describeResponse = this.namespace.describeTable(describeRequest);
        Assertions.assertNotNull((Object)describeResponse);
        Assertions.assertNotNull((Object)describeResponse.getLocation());
        Assertions.assertTrue((boolean)describeResponse.getLocation().contains("empty_table"));
        TableExistsRequest existsRequest = new TableExistsRequest();
        existsRequest.setId(tableId);
        this.namespace.tableExists(existsRequest);
    }

    @Test
    public void testCreateEmptyTableWithWrongLocation() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateEmptyTableRequest request = new CreateEmptyTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("test_table");
        request.setId(tableId);
        request.setLocation("/wrong/path/test_table.lance");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.namespace.createEmptyTable(request));
    }

    @Test
    public void testCreateEmptyTableThenDropIt() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("root", this.tempDir.toString());
        this.namespace.initialize(properties, allocator);
        CreateEmptyTableRequest createRequest = new CreateEmptyTableRequest();
        ArrayList<String> tableId = new ArrayList<String>();
        tableId.add("empty_table_to_drop");
        createRequest.setId(tableId);
        CreateEmptyTableResponse createResponse = this.namespace.createEmptyTable(createRequest);
        Assertions.assertNotNull((Object)createResponse);
        File tableDir = new File(this.tempDir.toFile(), "empty_table_to_drop.lance");
        Assertions.assertTrue((boolean)tableDir.exists());
        File reservedFile = new File(tableDir, ".lance-reserved");
        Assertions.assertTrue((boolean)reservedFile.exists());
        DropTableRequest dropRequest = new DropTableRequest();
        dropRequest.setId(tableId);
        DropTableResponse dropResponse = this.namespace.dropTable(dropRequest);
        Assertions.assertNotNull((Object)dropResponse);
        Assertions.assertFalse((boolean)tableDir.exists());
        Assertions.assertFalse((boolean)reservedFile.exists());
    }
}

