/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lancedb.lance.namespace.rest.RestClient;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRestClient {
    private HttpServer server;
    private RestClient client;
    private int port;

    @BeforeEach
    public void setUp() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(0), 0);
        this.port = this.server.getAddress().getPort();
        this.server.setExecutor(null);
        this.server.start();
        this.client = RestClient.builder().baseUrl("http://localhost:" + this.port).build();
    }

    @AfterEach
    public void tearDown() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    @Test
    public void testGet() throws IOException {
        TestResponse expectedResponse = new TestResponse("test", 123);
        this.server.createContext("/test", exchange -> {
            if (!"GET".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            String json = new ObjectMapper().writeValueAsString((Object)expectedResponse);
            byte[] response = json.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        });
        TestResponse response = (TestResponse)this.client.get("/test", TestResponse.class);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)expectedResponse.getName(), (Object)response.getName());
        Assertions.assertEquals((int)expectedResponse.getValue(), (int)response.getValue());
    }

    @Test
    public void testGetWithQueryParams() throws IOException {
        this.server.createContext("/search", exchange -> {
            String query = exchange.getRequestURI().getQuery();
            Assertions.assertEquals((Object)"q=test&limit=10", (Object)query);
            exchange.sendResponseHeaders(204, -1L);
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "test");
        params.put("limit", "10");
        this.client.get("/search", params, Void.class);
    }

    @Test
    public void testPost() throws IOException {
        TestRequest request = new TestRequest("create", "data");
        TestResponse expectedResponse = new TestResponse("created", 1);
        this.server.createContext("/create", exchange -> {
            int bytesRead;
            if (!"POST".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((bytesRead = exchange.getRequestBody().read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            byte[] requestBytes = buffer.toByteArray();
            TestRequest receivedRequest = (TestRequest)new ObjectMapper().readValue(requestBytes, TestRequest.class);
            Assertions.assertEquals((Object)request.getAction(), (Object)receivedRequest.getAction());
            Assertions.assertEquals((Object)request.getData(), (Object)receivedRequest.getData());
            String json = new ObjectMapper().writeValueAsString((Object)expectedResponse);
            byte[] response = json.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(200, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        });
        TestResponse response = (TestResponse)this.client.post("/create", (Object)request, TestResponse.class);
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)expectedResponse.getName(), (Object)response.getName());
        Assertions.assertEquals((int)expectedResponse.getValue(), (int)response.getValue());
    }

    @Test
    public void testDelete() throws IOException {
        this.server.createContext("/delete/123", exchange -> {
            if (!"DELETE".equals(exchange.getRequestMethod())) {
                exchange.sendResponseHeaders(405, -1L);
                return;
            }
            exchange.sendResponseHeaders(204, -1L);
        });
        this.client.delete("/delete/123");
    }

    @Test
    public void testErrorHandling() {
        this.server.createContext("/error", exchange -> {
            String errorJson = "{\"error\": \"Bad Request\"}";
            byte[] response = errorJson.getBytes(StandardCharsets.UTF_8);
            exchange.getResponseHeaders().add("Content-Type", "application/json");
            exchange.sendResponseHeaders(400, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        });
        RestClient.RestClientException exception = (RestClient.RestClientException)Assertions.assertThrows(RestClient.RestClientException.class, () -> this.client.get("/error", TestResponse.class));
        Assertions.assertEquals((int)400, (int)exception.getStatusCode());
        Assertions.assertTrue((boolean)exception.getResponseBody().contains("Bad Request"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRetry() throws IOException {
        AtomicInteger attempts = new AtomicInteger(0);
        this.server.createContext("/retry", exchange -> {
            int attempt = attempts.incrementAndGet();
            if (attempt < 3) {
                exchange.sendResponseHeaders(503, -1L);
            } else {
                String json = "{\"name\": \"success\", \"value\": 42}";
                byte[] response = json.getBytes(StandardCharsets.UTF_8);
                exchange.getResponseHeaders().add("Content-Type", "application/json");
                exchange.sendResponseHeaders(200, response.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
        });
        try (RestClient retryClient = RestClient.builder().baseUrl("http://localhost:" + this.port).maxRetries(3).retryDelayMs(100L).build();){
            TestResponse response = (TestResponse)retryClient.get("/retry", TestResponse.class);
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((Object)"success", (Object)response.getName());
            Assertions.assertEquals((int)42, (int)response.getValue());
            Assertions.assertEquals((int)3, (int)attempts.get());
        }
    }

    @Test
    public void testHeaders() throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer token123");
        headers.put("X-Custom-Header", "custom-value");
        try (RestClient clientWithHeaders = RestClient.builder().baseUrl("http://localhost:" + this.port).defaultHeaders(headers).build();){
            this.server.createContext("/headers", exchange -> {
                Assertions.assertEquals((Object)"Bearer token123", (Object)exchange.getRequestHeaders().getFirst("Authorization"));
                Assertions.assertEquals((Object)"custom-value", (Object)exchange.getRequestHeaders().getFirst("X-Custom-Header"));
                exchange.sendResponseHeaders(204, -1L);
            });
            clientWithHeaders.get("/headers", Void.class);
        }
    }

    @Test
    public void testNullResponse() throws IOException {
        this.server.createContext("/empty", exchange -> exchange.sendResponseHeaders(204, -1L));
        TestResponse response = (TestResponse)this.client.get("/empty", TestResponse.class);
        Assertions.assertNull((Object)response);
    }

    @Test
    public void testPutAndPatch() throws IOException {
        TestRequest request = new TestRequest("update", "newdata");
        this.server.createContext("/put", exchange -> {
            Assertions.assertEquals((Object)"PUT", (Object)exchange.getRequestMethod());
            exchange.sendResponseHeaders(204, -1L);
        });
        this.server.createContext("/patch", exchange -> {
            Assertions.assertEquals((Object)"PATCH", (Object)exchange.getRequestMethod());
            exchange.sendResponseHeaders(204, -1L);
        });
        this.client.put("/put", (Object)request, Void.class);
        this.client.patch("/patch", (Object)request, Void.class);
    }

    static class TestResponse {
        private String name;
        private int value;

        public TestResponse() {
        }

        public TestResponse(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }

    static class TestRequest {
        private String action;
        private String data;

        public TestRequest() {
        }

        public TestRequest(String action, String data) {
            this.action = action;
            this.data = data;
        }

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}

