/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import com.lancedb.lance.namespace.util.OpenDalUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestOpenDalUtil {
    @Test
    public void testNormalizeScheme() {
        Assertions.assertEquals((Object)"s3", (Object)OpenDalUtil.normalizeScheme((String)"s3"));
        Assertions.assertEquals((Object)"s3", (Object)OpenDalUtil.normalizeScheme((String)"s3a"));
        Assertions.assertEquals((Object)"s3", (Object)OpenDalUtil.normalizeScheme((String)"s3n"));
        Assertions.assertEquals((Object)"s3", (Object)OpenDalUtil.normalizeScheme((String)"S3A"));
        Assertions.assertEquals((Object)"azblob", (Object)OpenDalUtil.normalizeScheme((String)"azblob"));
        Assertions.assertEquals((Object)"azblob", (Object)OpenDalUtil.normalizeScheme((String)"az"));
        Assertions.assertEquals((Object)"azblob", (Object)OpenDalUtil.normalizeScheme((String)"abfs"));
        Assertions.assertEquals((Object)"azblob", (Object)OpenDalUtil.normalizeScheme((String)"AZ"));
        Assertions.assertEquals((Object)"azblob", (Object)OpenDalUtil.normalizeScheme((String)"ABFS"));
        Assertions.assertEquals((Object)"fs", (Object)OpenDalUtil.normalizeScheme((String)"file"));
        Assertions.assertEquals((Object)"fs", (Object)OpenDalUtil.normalizeScheme((String)"fs"));
        Assertions.assertEquals((Object)"fs", (Object)OpenDalUtil.normalizeScheme((String)"FILE"));
        Assertions.assertEquals((Object)"gcs", (Object)OpenDalUtil.normalizeScheme((String)"gcs"));
        Assertions.assertEquals((Object)"gcs", (Object)OpenDalUtil.normalizeScheme((String)"GCS"));
        Assertions.assertEquals((Object)"hdfs", (Object)OpenDalUtil.normalizeScheme((String)"hdfs"));
        Assertions.assertEquals((Object)"custom", (Object)OpenDalUtil.normalizeScheme((String)"custom"));
    }

    @Test
    public void testDenormalizeScheme() {
        Assertions.assertEquals((Object)"az", (Object)OpenDalUtil.denormalizeScheme((String)"azblob"));
        Assertions.assertEquals((Object)"az", (Object)OpenDalUtil.denormalizeScheme((String)"AZBLOB"));
        Assertions.assertEquals((Object)"s3", (Object)OpenDalUtil.denormalizeScheme((String)"s3"));
        Assertions.assertEquals((Object)"gcs", (Object)OpenDalUtil.denormalizeScheme((String)"gcs"));
        Assertions.assertEquals((Object)"fs", (Object)OpenDalUtil.denormalizeScheme((String)"fs"));
        Assertions.assertEquals((Object)"file", (Object)OpenDalUtil.denormalizeScheme((String)"file"));
        Assertions.assertEquals((Object)"hdfs", (Object)OpenDalUtil.denormalizeScheme((String)"hdfs"));
    }

    @Test
    public void testDenormalizeUri() {
        Assertions.assertEquals((Object)"az://container/path/to/table.lance", (Object)OpenDalUtil.denormalizeUri((String)"azblob://container/path/to/table.lance"));
        Assertions.assertEquals((Object)"az://mycontainer/data/mytable.lance", (Object)OpenDalUtil.denormalizeUri((String)"azblob://mycontainer/data/mytable.lance"));
        Assertions.assertEquals((Object)"s3://bucket/path/to/table.lance", (Object)OpenDalUtil.denormalizeUri((String)"s3://bucket/path/to/table.lance"));
        Assertions.assertEquals((Object)"gcs://bucket/path/to/table.lance", (Object)OpenDalUtil.denormalizeUri((String)"gcs://bucket/path/to/table.lance"));
        Assertions.assertEquals((Object)"file:///local/path/to/table.lance", (Object)OpenDalUtil.denormalizeUri((String)"file:///local/path/to/table.lance"));
        Assertions.assertEquals((Object)"/local/path/to/table.lance", (Object)OpenDalUtil.denormalizeUri((String)"/local/path/to/table.lance"));
        Assertions.assertNull((Object)OpenDalUtil.denormalizeUri(null));
        Assertions.assertEquals((Object)"", (Object)OpenDalUtil.denormalizeUri((String)""));
        Assertions.assertEquals((Object)"noscheme", (Object)OpenDalUtil.denormalizeUri((String)"noscheme"));
    }

    @Test
    public void testStripTrailingSlash() {
        Assertions.assertEquals((Object)"/path/to/dir", (Object)OpenDalUtil.stripTrailingSlash((String)"/path/to/dir/"));
        Assertions.assertEquals((Object)"/path/to/dir", (Object)OpenDalUtil.stripTrailingSlash((String)"/path/to/dir//"));
        Assertions.assertEquals((Object)"s3://bucket/path", (Object)OpenDalUtil.stripTrailingSlash((String)"s3://bucket/path///"));
        Assertions.assertEquals((Object)"/path/to/dir", (Object)OpenDalUtil.stripTrailingSlash((String)"/path/to/dir"));
        Assertions.assertEquals((Object)"s3://bucket/path", (Object)OpenDalUtil.stripTrailingSlash((String)"s3://bucket/path"));
        Assertions.assertNull((Object)OpenDalUtil.stripTrailingSlash(null));
        Assertions.assertEquals((Object)"", (Object)OpenDalUtil.stripTrailingSlash((String)"/"));
        Assertions.assertEquals((Object)"", (Object)OpenDalUtil.stripTrailingSlash((String)"///"));
    }
}

