/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.lancedb.lance.namespace.client.apache.ApiException;
import com.lancedb.lance.namespace.model.ErrorResponse;
import com.lancedb.lance.namespace.util.JsonUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanceNamespaceException
extends RuntimeException {
    private static final Logger LOG = LoggerFactory.getLogger(LanceNamespaceException.class);
    private final int UNKNOWN_ERROR_CODE = -1;
    private final int code;
    private final Optional<ErrorResponse> errorResponse;

    public LanceNamespaceException(int code, String responseBody) {
        super(responseBody);
        this.code = code;
        this.errorResponse = Optional.empty();
    }

    public LanceNamespaceException(ApiException e) {
        super(e.getResponseBody() == null ? e.getMessage() : e.getResponseBody(), e);
        Optional<Object> res = Optional.empty();
        this.code = e.getCode();
        if (e.getResponseBody() != null) {
            try {
                res = Optional.of((ErrorResponse)JsonUtil.mapper().readValue(e.getResponseBody(), ErrorResponse.class));
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        this.errorResponse = res;
    }

    public LanceNamespaceException(ErrorResponse errorResponse) {
        super(errorResponse.getError());
        this.code = errorResponse.getCode() == null ? -1 : errorResponse.getCode();
        this.errorResponse = Optional.of(errorResponse);
    }

    public int getCode() {
        return this.code;
    }

    public Optional<ErrorResponse> getErrorResponse() {
        return this.errorResponse;
    }

    public static LanceNamespaceException badRequest(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(400));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException unauthorized(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(401));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException forbidden(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(403));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException notFound(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(404));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException unsupportedOperation(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(406));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException conflict(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(409));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException serviceUnavailable(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(504));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }

    public static LanceNamespaceException serverError(String error, String type, String instance, String detail) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setError(error);
        errorResponse.type(type);
        errorResponse.setCode(Integer.valueOf(500));
        errorResponse.setDetail(detail);
        errorResponse.setInstance(instance);
        return new LanceNamespaceException(errorResponse);
    }
}

