/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.dir;

import com.lancedb.lance.Dataset;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.dir.DirectoryNamespaceConfig;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.util.JsonArrowSchemaConverter;
import com.lancedb.lance.namespace.util.OpenDalUtil;
import com.lancedb.lance.namespace.util.ValidationUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.opendal.Entry;
import org.apache.opendal.ListOptions;
import org.apache.opendal.Operator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryNamespace
implements LanceNamespace,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryNamespace.class);
    private DirectoryNamespaceConfig config;
    private Operator operator;
    private BufferAllocator allocator;

    @Override
    public void initialize(Map<String, String> configProperties, BufferAllocator allocator) {
        this.config = new DirectoryNamespaceConfig(configProperties);
        this.allocator = allocator;
        this.operator = OpenDalUtil.initializeOperator(this.config.getRoot());
    }

    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        throw new UnsupportedOperationException("Directory namespace only contains a flat list of tables");
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        throw new UnsupportedOperationException("Directory namespace only contains a flat list of tables");
    }

    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest request) {
        throw new UnsupportedOperationException("Directory namespace only contains a flat list of tables");
    }

    @Override
    public DropNamespaceResponse dropNamespace(DropNamespaceRequest request) {
        throw new UnsupportedOperationException("Directory namespace only contains a flat list of tables");
    }

    @Override
    public void namespaceExists(NamespaceExistsRequest request) {
        throw new UnsupportedOperationException("Directory namespace only contains a flat list of tables");
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest request, byte[] requestData) {
        String tableName = this.tableNameFromId(request.getId());
        ValidationUtil.checkNotNull(request.getSchema(), "Schema is required in CreateTableRequest", new Object[0]);
        Schema schema = JsonArrowSchemaConverter.convertToArrowSchema(request.getSchema());
        WriteParams writeParams = new WriteParams.Builder().withMode(WriteParams.WriteMode.CREATE).withStorageOptions(this.config.getStorageOptions()).build();
        String tablePath = this.tableFullPath(tableName);
        ValidationUtil.checkArgument(request.getLocation() == null || OpenDalUtil.stripTrailingSlash(request.getLocation()).equals(tablePath), "Cannot create table %s at location %s, must be at location %s", tableName, request.getLocation(), tablePath);
        Dataset.create((BufferAllocator)this.allocator, (String)tablePath, (Schema)schema, (WriteParams)writeParams);
        CreateTableResponse response = new CreateTableResponse();
        response.setLocation(tablePath);
        response.setVersion(Long.valueOf(1L));
        return response;
    }

    @Override
    public DropTableResponse dropTable(DropTableRequest request) {
        String tableName = this.tableNameFromId(request.getId());
        String tablePath = this.tableFullPath(tableName);
        LOG.debug("Dropping table {} at path {}", (Object)tableName, (Object)tablePath);
        try {
            Dataset.drop((String)tablePath, this.config.getStorageOptions());
            DropTableResponse response = new DropTableResponse();
            response.setLocation(tablePath);
            response.setId(request.getId());
            return response;
        }
        catch (Exception e) {
            throw LanceNamespaceException.serverError("Failed to drop table: " + tableName, "TABLE_DROP_ERROR", tableName, "An error occurred while attempting to drop the table: " + e.getMessage());
        }
    }

    @Override
    public ListTablesResponse listTables(ListTablesRequest request) {
        this.validateRootNamespaceId(request.getId());
        HashSet<String> tables = new HashSet<String>();
        List entries = this.operator.list("", ListOptions.builder().recursive(false).build());
        for (Entry entry : entries) {
            String path = OpenDalUtil.stripTrailingSlash(entry.getPath());
            if (!path.contains(".lance")) continue;
            String tableName = path.substring(0, path.length() - 6);
            try {
                String versionsPath = this.tableVersionsPath(tableName);
                List versionEntries = this.operator.list(versionsPath, ListOptions.builder().limit(1L).build());
                if (versionEntries.isEmpty()) continue;
                tables.add(tableName);
            }
            catch (Exception e) {
                LOG.debug("Invalid Lance table directory {}, skipping", (Object)path);
            }
        }
        ListTablesResponse response = new ListTablesResponse();
        response.setTables(tables);
        return response;
    }

    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest request) {
        String tableName = this.tableNameFromId(request.getId());
        String tablePath = this.tableFullPath(tableName);
        LOG.debug("Describing table {} at path {}", (Object)tableName, (Object)tablePath);
        try {
            String versionsPath = this.tableVersionsPath(tableName);
            List versionEntries = this.operator.list(versionsPath, ListOptions.builder().limit(1L).build());
            if (versionEntries.isEmpty()) {
                throw LanceNamespaceException.notFound("Table does not exist: " + tableName, "TABLE_NOT_FOUND", tableName, "The requested table was not found in the namespace");
            }
        }
        catch (Exception e) {
            throw LanceNamespaceException.notFound("Table does not exist: " + tableName, "TABLE_NOT_FOUND", tableName, "The requested table was not found in the namespace: " + e.getMessage());
        }
        DescribeTableResponse response = new DescribeTableResponse();
        response.setLocation(tablePath);
        return response;
    }

    private void validateRootNamespaceId(List<String> id) {
        ValidationUtil.checkArgument(id == null || id.isEmpty(), String.format("Directory namespace only supports root namespace operations, but got namespace ID: %s. Expected empty ID.", id), new Object[0]);
    }

    private String tableNameFromId(List<String> id) {
        ValidationUtil.checkArgument(id != null && !id.isEmpty(), "Directory namespace table ID cannot be empty", new Object[0]);
        ValidationUtil.checkArgument(id.size() == 1, "Directory namespace only supports single-level table IDs, but got: %s", id);
        return id.get(0);
    }

    private String tableFullPath(String tableName) {
        return String.format("%s/%s.lance", this.config.getRoot(), tableName);
    }

    private String tableVersionsPath(String tableName) {
        return String.format("%s.lance/_versions/", tableName);
    }

    @Override
    public void close() throws IOException {
        this.operator.close();
    }
}

