/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.opendal.Operator;

public class OpenDalUtil {
    private OpenDalUtil() {
    }

    public static Operator initializeOperator(String root) {
        String[] schemeSplit = root.split("://", -1);
        if (schemeSplit.length < 2) {
            return Operator.of((String)"fs", (Map)ImmutableMap.of((Object)"root", (Object)root));
        }
        String scheme = OpenDalUtil.normalizeScheme(schemeSplit[0]);
        String[] authoritySplit = schemeSplit[1].split("/", 2);
        String authority = authoritySplit[0];
        String path = authoritySplit.length > 1 ? authoritySplit[1] : "";
        switch (scheme) {
            case "s3": 
            case "gcs": {
                return Operator.of((String)scheme, (Map)ImmutableMap.of((Object)"root", (Object)path, (Object)"bucket", (Object)authority));
            }
            case "azblob": {
                return Operator.of((String)scheme, (Map)ImmutableMap.of((Object)"root", (Object)path, (Object)"CONTAINER", (Object)authority));
            }
        }
        return Operator.of((String)scheme, (Map)ImmutableMap.of((Object)"root", (Object)schemeSplit[1]));
    }

    public static String normalizeScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "s3a": 
            case "s3n": {
                return "s3";
            }
            case "abfs": {
                return "azblob";
            }
            case "file": {
                return "fs";
            }
        }
        return scheme.toLowerCase();
    }

    public static String stripTrailingSlash(String path) {
        if (path == null) {
            return null;
        }
        String result = path;
        while (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

