/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.util;

public class ValidationUtil {
    private ValidationUtil() {
    }

    public static void checkArgument(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalArgumentException(String.format(message, args));
        }
    }

    public static void checkNotNull(Object object, String message, Object ... args) {
        ValidationUtil.checkArgument(object != null, message, args);
    }

    public static void checkNotNullOrEmptyString(String str, String message, Object ... args) {
        ValidationUtil.checkArgument(str != null && !str.isEmpty(), message, args);
    }

    public static void checkState(boolean expression, String message, Object ... args) {
        if (!expression) {
            throw new IllegalStateException(String.format(message, args));
        }
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }
}

