/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.glue;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.lancedb.lance.namespace.util.OpenDalUtil;
import com.lancedb.lance.namespace.util.PropertyUtil;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.glue.GlueClientBuilder;

public class GlueNamespaceConfig
implements Serializable {
    public static final String CATALOG_ID = "catalog_id";
    public static final String ENDPOINT = "endpoint";
    public static final String REGION = "region";
    public static final String ACCESS_KEY_ID = "access_key_id";
    public static final String SECRET_ACCESS_KEY = "secret_access_key";
    public static final String SESSION_TOKEN = "session_token";
    public static final String STORAGE_OPTIONS_PREFIX = "storage.";
    public static final String ROOT = "root";
    public static final String ROOT_DEFAULT = System.getProperty("user.dir");
    private final String endpoint;
    private final String region;
    private final String catalogId;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final Map<String, String> storageOptions;
    private final String root;

    public GlueNamespaceConfig() {
        this.catalogId = null;
        this.endpoint = null;
        this.region = null;
        this.accessKeyId = null;
        this.secretAccessKey = null;
        this.sessionToken = null;
        this.storageOptions = ImmutableMap.of();
        this.root = ROOT_DEFAULT;
    }

    public GlueNamespaceConfig(Map<String, String> properties) {
        this.endpoint = properties.get(ENDPOINT);
        this.region = properties.get(REGION);
        this.catalogId = properties.get(CATALOG_ID);
        this.accessKeyId = properties.get(ACCESS_KEY_ID);
        this.secretAccessKey = properties.get(SECRET_ACCESS_KEY);
        this.sessionToken = properties.get(SESSION_TOKEN);
        this.storageOptions = PropertyUtil.propertiesWithPrefix(properties, (String)STORAGE_OPTIONS_PREFIX);
        this.root = OpenDalUtil.stripTrailingSlash((String)PropertyUtil.propertyAsString(properties, (String)ROOT, (String)ROOT_DEFAULT));
    }

    public String catalogId() {
        return this.catalogId;
    }

    private AwsCredentialsProvider credentialsProvider() {
        if (!Strings.isNullOrEmpty((String)this.accessKeyId) && !Strings.isNullOrEmpty((String)this.secretAccessKey)) {
            return StaticCredentialsProvider.create((AwsCredentials)(Strings.isNullOrEmpty((String)this.sessionToken) ? AwsBasicCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey) : AwsSessionCredentials.create((String)this.accessKeyId, (String)this.secretAccessKey, (String)this.sessionToken)));
        }
        return DefaultCredentialsProvider.builder().build();
    }

    public void configureClientBuilder(GlueClientBuilder builder) {
        if (!Strings.isNullOrEmpty((String)this.endpoint)) {
            builder.endpointOverride(URI.create(this.endpoint));
        }
        if (!Strings.isNullOrEmpty((String)this.region)) {
            builder.region(Region.of((String)this.region));
        }
        builder.credentialsProvider(this.credentialsProvider());
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public String getRoot() {
        return this.root;
    }
}

