/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.glue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.glue.GlueNamespaceConfig;
import com.lancedb.lance.namespace.glue.GlueToLanceErrorConverter;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DeregisterTableRequest;
import com.lancedb.lance.namespace.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.RegisterTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableResponse;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.util.JsonArrowSchemaConverter;
import com.lancedb.lance.namespace.util.OpenDalUtil;
import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.opendal.Operator;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesRequest;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableVersionRequest;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GlueException;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;

public class GlueNamespace
implements LanceNamespace,
Closeable {
    private static final String PARAM_LOCATION = "location";
    private static final String PARAM_DESCRIPTION = "description";
    public static final String TABLE_TYPE_PROP = "table_type";
    public static final String LANCE_TABLE_TYPE_VALUE = "lance";
    public static final String MANAGED_BY_PROP = "managed_by";
    public static final String STORAGE_VALUE = "storage";
    public static final String VERSION_PROP = "version";
    private static final int MAX_LISTING_SIZE = 100;
    private GlueNamespaceConfig config;
    private GlueClient glueClient;
    private BufferAllocator allocator;

    public void initialize(Map<String, String> configProperties, BufferAllocator allocator) {
        GlueNamespaceConfig glueProperties = new GlueNamespaceConfig(configProperties);
        GlueClient glueClient = (GlueClient)((GlueClientBuilder)GlueClient.builder().applyMutation(glueProperties::configureClientBuilder)).build();
        this.initialize(glueProperties, glueClient, allocator);
    }

    @VisibleForTesting
    void initialize(GlueNamespaceConfig properties, GlueClient glueClient, BufferAllocator allocator) {
        this.config = properties;
        this.glueClient = glueClient;
        this.allocator = allocator;
    }

    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        int pageSize;
        this.validateParent(request.getId());
        GetDatabasesRequest.Builder listRequest = GetDatabasesRequest.builder().catalogId(this.config.catalogId());
        int remaining = pageSize = request.getLimit() != null ? request.getLimit() : Integer.MAX_VALUE;
        String glueNextToken = request.getPageToken();
        HashSet databases = Sets.newHashSet();
        do {
            int fetchSize = Math.min(remaining, 100);
            GetDatabasesResponse response = this.glueClient.getDatabases((GetDatabasesRequest)listRequest.maxResults(Integer.valueOf(fetchSize)).nextToken(glueNextToken).build());
            response.databaseList().forEach(d -> databases.add(d.name()));
            glueNextToken = response.nextToken();
            remaining = pageSize - databases.size();
        } while (glueNextToken != null && remaining > 0);
        return new ListNamespacesResponse().namespaces((Set)databases).pageToken(glueNextToken);
    }

    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest request) {
        String namespaceName = this.namespaceFromId(request.getId());
        Database database = this.getDatabase(namespaceName);
        Map<String, String> glueProperties = GlueNamespace.extractDatabaseProperties(database);
        return new DescribeNamespaceResponse().properties(glueProperties);
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        String namespaceName = this.namespaceFromId(request.getId());
        CreateNamespaceRequest.ModeEnum mode = request.getMode() != null ? request.getMode() : CreateNamespaceRequest.ModeEnum.CREATE;
        Object params = request.getProperties() != null ? request.getProperties() : ImmutableMap.of();
        boolean namespaceExists = this.databaseExists(namespaceName);
        switch (mode) {
            case EXIST_OK: {
                if (!namespaceExists) break;
                return this.describeNamespaceAsCreateResponse(namespaceName);
            }
            case OVERWRITE: {
                if (!namespaceExists) break;
                this.deleteDatabase(namespaceName);
            }
        }
        try {
            this.glueClient.createDatabase((CreateDatabaseRequest)CreateDatabaseRequest.builder().catalogId(this.config.catalogId()).databaseInput(this.buildDatabaseInput(namespaceName, (Map<String, String>)params)).build());
            return new CreateNamespaceResponse().properties((Map)params);
        }
        catch (AlreadyExistsException e) {
            if (mode == CreateNamespaceRequest.ModeEnum.EXIST_OK) {
                return this.describeNamespaceAsCreateResponse(namespaceName);
            }
            throw GlueToLanceErrorConverter.conflict((GlueException)((Object)e), "Namespace already exists: %s", namespaceName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to create namespace: %s", namespaceName);
        }
    }

    public DropNamespaceResponse dropNamespace(DropNamespaceRequest request) {
        DropNamespaceRequest.BehaviorEnum behavior;
        String namespaceName = this.namespaceFromId(request.getId());
        DropNamespaceRequest.ModeEnum mode = request.getMode() != null ? request.getMode() : DropNamespaceRequest.ModeEnum.FAIL;
        DropNamespaceRequest.BehaviorEnum behaviorEnum = behavior = request.getBehavior() != null ? request.getBehavior() : DropNamespaceRequest.BehaviorEnum.RESTRICT;
        if (!this.databaseExists(namespaceName)) {
            if (mode == DropNamespaceRequest.ModeEnum.SKIP) {
                return new DropNamespaceResponse();
            }
            throw LanceNamespaceException.badRequest((String)("Namespace not found: " + namespaceName), (String)"NAMESPACE_NOT_FOUND", (String)namespaceName, (String)"The requested namespace does not exist");
        }
        switch (behavior) {
            case CASCADE: {
                this.deleteAllTables(namespaceName);
                break;
            }
            case RESTRICT: {
                this.ensureNamespaceEmpty(namespaceName);
            }
        }
        this.deleteDatabase(namespaceName);
        return new DropNamespaceResponse();
    }

    public void namespaceExists(NamespaceExistsRequest request) {
        String namespaceName = this.namespaceFromId(request.getId());
        this.getDatabase(namespaceName);
    }

    public ListTablesResponse listTables(ListTablesRequest request) {
        String namespaceName = this.namespaceFromId(request.getId());
        try {
            int pageSize;
            GetTablesRequest.Builder listRequest = GetTablesRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName);
            int remaining = pageSize = request.getLimit() != null ? request.getLimit() : Integer.MAX_VALUE;
            String glueNextToken = request.getPageToken();
            HashSet tables = Sets.newHashSet();
            do {
                int fetchSize = Math.min(remaining, 100);
                GetTablesResponse response = this.glueClient.getTables((GetTablesRequest)listRequest.maxResults(Integer.valueOf(fetchSize)).nextToken(glueNextToken).build());
                response.tableList().stream().filter(this::isLanceTable).forEach(t -> tables.add(t.name()));
                glueNextToken = response.nextToken();
                remaining = pageSize - tables.size();
            } while (glueNextToken != null && remaining > 0);
            return new ListTablesResponse().tables((Set)tables).pageToken(glueNextToken);
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue database not found: %s", namespaceName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to list tables in Glue database: %s", namespaceName);
        }
    }

    public DescribeTableResponse describeTable(DescribeTableRequest request) {
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        Table table = this.getGlueTableAtVersion(namespaceName, tableName, request.getVersion());
        this.ensureLanceTable(table);
        DescribeTableResponse response = new DescribeTableResponse();
        if (table.storageDescriptor() != null && table.storageDescriptor().location() != null) {
            response.setLocation(table.storageDescriptor().location());
        }
        response.setStorageOptions(this.config.getStorageOptions());
        return response;
    }

    public RegisterTableResponse registerTable(RegisterTableRequest request) {
        RegisterTableRequest.ModeEnum mode;
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        if (request.getLocation().isEmpty()) {
            throw LanceNamespaceException.badRequest((String)"Table location is required", (String)"BAD_REQUEST", (String)"", (String)"");
        }
        String location = OpenDalUtil.stripTrailingSlash((String)request.getLocation());
        RegisterTableRequest.ModeEnum modeEnum = mode = request.getMode() != null ? request.getMode() : RegisterTableRequest.ModeEnum.CREATE;
        if (mode == RegisterTableRequest.ModeEnum.OVERWRITE) {
            this.deleteGlueTable(namespaceName, tableName, false);
        }
        try {
            HashMap params = Maps.newHashMap();
            if (request.getProperties() != null) {
                params.putAll(request.getProperties());
            }
            params.put(TABLE_TYPE_PROP, LANCE_TABLE_TYPE_VALUE);
            params.put(MANAGED_BY_PROP, STORAGE_VALUE);
            TableInput tableInput = (TableInput)TableInput.builder().name(tableName).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().location(location).parameters((Map)params).build()).build();
            this.glueClient.createTable((CreateTableRequest)CreateTableRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).tableInput(tableInput).build());
            RegisterTableResponse response = new RegisterTableResponse();
            response.setLocation(location);
            response.setProperties(request.getProperties());
            return response;
        }
        catch (AlreadyExistsException e) {
            throw GlueToLanceErrorConverter.conflict((GlueException)((Object)e), "Table already exists: %s.%s", namespaceName, tableName);
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Namespace not found: %s", namespaceName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to register table: %s.%s", namespaceName, tableName);
        }
    }

    public DeregisterTableResponse deregisterTable(DeregisterTableRequest request) {
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        try {
            Table table = this.getGlueTable(namespaceName, tableName);
            this.ensureLanceTable(table);
            this.deleteGlueTable(namespaceName, tableName, false);
            DeregisterTableResponse response = new DeregisterTableResponse();
            response.setId(request.getId());
            if (table.storageDescriptor() != null && table.storageDescriptor().location() != null) {
                response.setLocation(table.storageDescriptor().location());
            }
            if (table.parameters() != null && !table.parameters().isEmpty()) {
                response.setProperties(table.parameters());
            }
            return response;
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue table not found: %s.%s", namespaceName, tableName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to deregister table: %s.%s", namespaceName, tableName);
        }
    }

    public CreateTableResponse createTable(com.lancedb.lance.namespace.model.CreateTableRequest request, byte[] requestData) {
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        String location = request.getLocation();
        if (location == null || location.isEmpty()) {
            location = this.getDefaultTableLocation(namespaceName, tableName);
        }
        try {
            HashMap params = Maps.newHashMap();
            if (request.getProperties() != null) {
                params.putAll(request.getProperties());
            }
            params.put(TABLE_TYPE_PROP, LANCE_TABLE_TYPE_VALUE);
            params.put(MANAGED_BY_PROP, params.getOrDefault(MANAGED_BY_PROP, STORAGE_VALUE));
            params.put(VERSION_PROP, "1");
            this.validateSchemaNotNull(request.getSchema(), namespaceName, tableName);
            Schema schema = JsonArrowSchemaConverter.convertToArrowSchema((JsonArrowSchema)request.getSchema());
            WriteParams writeParams = new WriteParams.Builder().withMode(WriteParams.WriteMode.CREATE).withStorageOptions(this.config.getStorageOptions()).build();
            try {
                Dataset.create((BufferAllocator)this.allocator, (String)location, (Schema)schema, (WriteParams)writeParams);
            }
            catch (Exception e) {
                throw LanceNamespaceException.serverError((String)("Failed to create Lance dataset at location: " + location), (String)"DATASET_CREATE_ERROR", (String)location, (String)("An error occurred while creating the Lance dataset: " + e.getMessage()));
            }
            TableInput tableInput = (TableInput)TableInput.builder().name(tableName).storageDescriptor((StorageDescriptor)StorageDescriptor.builder().location(location).parameters((Map)params).build()).parameters((Map)params).build();
            this.glueClient.createTable((CreateTableRequest)CreateTableRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).tableInput(tableInput).build());
            CreateTableResponse response = new CreateTableResponse();
            response.setLocation(location);
            response.setVersion(Long.valueOf(1L));
            response.setProperties(request.getProperties());
            response.setStorageOptions(this.config.getStorageOptions());
            return response;
        }
        catch (GlueException e) {
            this.safeDropDataset(location);
            if (e instanceof AlreadyExistsException) {
                throw GlueToLanceErrorConverter.conflict(e, "Table already exists: %s.%s", namespaceName, tableName);
            }
            if (e instanceof EntityNotFoundException) {
                throw GlueToLanceErrorConverter.notFound(e, "Namespace not found: %s", namespaceName);
            }
            throw GlueToLanceErrorConverter.serverError(e, "Failed to create table: %s.%s", namespaceName, tableName);
        }
    }

    public DropTableResponse dropTable(DropTableRequest request) {
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        Table table = this.getGlueTable(namespaceName, tableName);
        this.ensureLanceTable(table);
        String tableLocation = null;
        if (table.storageDescriptor() != null && table.storageDescriptor().location() != null) {
            tableLocation = OpenDalUtil.stripTrailingSlash((String)table.storageDescriptor().location());
        }
        try {
            Dataset.drop(tableLocation, this.config.getStorageOptions());
        }
        catch (Exception e) {
            throw LanceNamespaceException.serverError((String)("Failed to drop Lance dataset at location: " + tableLocation), (String)"DATASET_DROP_ERROR", (String)tableLocation, (String)e.getMessage());
        }
        this.deleteGlueTable(namespaceName, tableName, false);
        DropTableResponse response = new DropTableResponse();
        response.setId(request.getId());
        response.setLocation(tableLocation);
        if (table.parameters() != null && !table.parameters().isEmpty()) {
            response.setProperties(table.parameters());
        }
        return response;
    }

    public void tableExists(TableExistsRequest request) {
        this.validateTableId(request.getId());
        String namespaceName = (String)request.getId().get(0);
        String tableName = (String)request.getId().get(1);
        Table table = this.getGlueTableAtVersion(namespaceName, tableName, request.getVersion());
        this.ensureLanceTable(table);
    }

    private void validateParent(List<String> id) {
        if (id != null && id.size() > 1) {
            String instance = String.join((CharSequence)"/", id);
            throw LanceNamespaceException.badRequest((String)("Glue does not support nested namespaces. Found nested path: " + String.join((CharSequence)"/", id)), (String)"BAD_REQUEST", (String)instance, (String)"Nested namespaces must have only one parent");
        }
    }

    private String namespaceFromId(List<String> id) {
        if (id == null || id.isEmpty()) {
            throw LanceNamespaceException.badRequest((String)"Namespace identifier cannot be null or empty", (String)"BAD_REQUEST", (String)"", (String)"");
        }
        this.validateParent(id);
        String namespace = id.get(0);
        if (namespace == null || namespace.isEmpty()) {
            throw LanceNamespaceException.badRequest((String)"Namespace name cannot be empty", (String)"BAD_REQUEST", (String)"", (String)"");
        }
        return namespace;
    }

    private void validateTableId(List<String> id) {
        if (id == null || id.size() != 2) {
            throw LanceNamespaceException.badRequest((String)("Table identifier must contain exactly 2 elements, but got " + id), (String)"BAD_REQUEST", (String)(id != null ? String.join((CharSequence)"/", id) : ""), (String)"Expected format: [namespace, table]");
        }
        if (id.get(0) == null || id.get(0).isEmpty()) {
            throw LanceNamespaceException.badRequest((String)"Namespace name cannot be empty", (String)"BAD_REQUEST", (String)"", (String)"");
        }
        if (id.get(1) == null || id.get(1).isEmpty()) {
            throw LanceNamespaceException.badRequest((String)"Table name cannot be empty", (String)"BAD_REQUEST", (String)"", (String)"");
        }
    }

    private static Map<String, String> extractDatabaseProperties(Database database) {
        HashMap glueProperties;
        HashMap hashMap = glueProperties = database.parameters() != null ? Maps.newHashMap((Map)database.parameters()) : Maps.newHashMap();
        if (database.locationUri() != null) {
            glueProperties.put(PARAM_LOCATION, database.locationUri());
        }
        if (database.description() != null) {
            glueProperties.put(PARAM_DESCRIPTION, database.description());
        }
        return glueProperties;
    }

    private boolean databaseExists(String namespaceName) {
        try {
            this.glueClient.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.config.catalogId()).name(namespaceName).build());
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to get Glue database: %s", namespaceName);
        }
    }

    private Database getDatabase(String namespaceName) {
        try {
            return this.glueClient.getDatabase((GetDatabaseRequest)GetDatabaseRequest.builder().catalogId(this.config.catalogId()).name(namespaceName).build()).database();
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue database not found: %s", namespaceName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to get Glue database: %s", namespaceName);
        }
    }

    private void deleteDatabase(String namespaceName) {
        try {
            this.glueClient.deleteDatabase((DeleteDatabaseRequest)DeleteDatabaseRequest.builder().catalogId(this.config.catalogId()).name(namespaceName).build());
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to drop Glue namespace: %s", namespaceName);
        }
    }

    private DatabaseInput buildDatabaseInput(String namespaceName, Map<String, String> params) {
        DatabaseInput.Builder builder = DatabaseInput.builder().name(namespaceName);
        if (params.containsKey(PARAM_LOCATION)) {
            String location = OpenDalUtil.stripTrailingSlash((String)params.get(PARAM_LOCATION));
            builder.locationUri(location);
        }
        if (params.containsKey(PARAM_DESCRIPTION)) {
            builder.description(params.get(PARAM_DESCRIPTION));
        }
        HashMap parameters = Maps.newHashMap(params);
        parameters.remove(PARAM_LOCATION);
        parameters.remove(PARAM_DESCRIPTION);
        if (!parameters.isEmpty()) {
            builder.parameters((Map)parameters);
        }
        return (DatabaseInput)builder.build();
    }

    private CreateNamespaceResponse describeNamespaceAsCreateResponse(String namespaceName) {
        Database existing = this.getDatabase(namespaceName);
        Map<String, String> properties = GlueNamespace.extractDatabaseProperties(existing);
        return new CreateNamespaceResponse().properties(properties);
    }

    private void deleteAllTables(String namespaceName) {
        try {
            GetTablesResponse tablesResponse;
            String nextToken = null;
            do {
                tablesResponse = this.glueClient.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).nextToken(nextToken).build());
                for (Table table : tablesResponse.tableList()) {
                    if (table.storageDescriptor() != null && table.storageDescriptor().location() != null) {
                        String tableLocation = OpenDalUtil.stripTrailingSlash((String)table.storageDescriptor().location());
                        if (this.isLanceTable(table)) {
                            try {
                                Dataset.drop((String)tableLocation, this.config.getStorageOptions());
                            }
                            catch (Exception e) {
                                throw LanceNamespaceException.serverError((String)String.format("Failed to drop table: %s.%s", namespaceName, table.name()), (String)"TABLE_DROP_ERROR", (String)(namespaceName + "." + table.name()), (String)e.getMessage());
                            }
                        }
                        try (Operator op = OpenDalUtil.initializeOperator((String)tableLocation, this.config.getStorageOptions());){
                            op.removeAll("");
                        }
                        catch (Exception e) {
                            throw LanceNamespaceException.serverError((String)String.format("Failed to drop table: %s.%s", namespaceName, table.name()), (String)"TABLE_DROP_ERROR", (String)(namespaceName + "." + table.name()), (String)e.getMessage());
                        }
                    }
                    this.deleteGlueTable(namespaceName, table.name(), true);
                }
            } while ((nextToken = tablesResponse.nextToken()) != null);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to delete tables in glue database: %s", namespaceName);
        }
    }

    private void ensureNamespaceEmpty(String namespaceName) {
        try {
            GetTablesResponse tablesResponse = this.glueClient.getTables((GetTablesRequest)GetTablesRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).build());
            if (!tablesResponse.tableList().isEmpty()) {
                throw LanceNamespaceException.badRequest((String)("Namespace not empty: " + namespaceName), (String)"BAD_REQUEST", (String)namespaceName, (String)"");
            }
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to ensure Glue database is empty: %s", namespaceName);
        }
    }

    private boolean isLanceTable(Table table) {
        if (table == null || table.parameters() == null) {
            return false;
        }
        return LANCE_TABLE_TYPE_VALUE.equalsIgnoreCase((String)table.parameters().get(TABLE_TYPE_PROP));
    }

    private void ensureLanceTable(Table table) {
        if (!this.isLanceTable(table)) {
            throw LanceNamespaceException.notFound((String)String.format("Table not found: %s.%s", table.databaseName(), table.name()), (String)"NOT_LANCE_TABLE", (String)(table.databaseName() + "." + table.name()), (String)"");
        }
    }

    private String getDefaultTableLocation(String namespaceName, String tableName) {
        Database db = this.getDatabase(namespaceName);
        String dbUri = db.locationUri();
        if (dbUri == null || dbUri.isEmpty()) {
            String rootConfig = this.config.getRoot();
            if (rootConfig == null) {
                throw new IllegalStateException("Root configuration is null - cannot derive table location");
            }
            return String.format("%s/%s/%s.lance", rootConfig, namespaceName, tableName);
        }
        String base = OpenDalUtil.stripTrailingSlash((String)dbUri);
        return String.format("%s/%s.lance", base, tableName);
    }

    private Table getGlueTable(String namespace, String tableName) {
        try {
            return this.glueClient.getTable((GetTableRequest)GetTableRequest.builder().catalogId(this.config.catalogId()).databaseName(namespace).name(tableName).build()).table();
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue table not found: %s.%s", namespace, tableName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to get Glue table: %s.%s", namespace, tableName);
        }
    }

    private void deleteGlueTable(String namespaceName, String tableName, boolean failIfNotFound) {
        try {
            this.glueClient.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).name(tableName).build());
        }
        catch (EntityNotFoundException e) {
            if (failIfNotFound) {
                throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue table not found: %s.%s", namespaceName, tableName);
            }
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to delete Glue table: %s.%s", namespaceName, tableName);
        }
    }

    private Table getGlueTableAtVersion(String namespaceName, String tableName, Long version) {
        try {
            Table table;
            if (version != null) {
                String tableVersion = String.valueOf(version);
                table = this.glueClient.getTableVersion((GetTableVersionRequest)GetTableVersionRequest.builder().catalogId(this.config.catalogId()).databaseName(namespaceName).tableName(tableName).versionId(tableVersion).build()).tableVersion().table();
            } else {
                table = this.getGlueTable(namespaceName, tableName);
            }
            return table;
        }
        catch (EntityNotFoundException e) {
            throw GlueToLanceErrorConverter.notFound((GlueException)((Object)e), "Glue table not found: %s.%s", namespaceName, tableName);
        }
        catch (GlueException e) {
            throw GlueToLanceErrorConverter.serverError(e, "Failed to get Glue table: %s.%s", namespaceName, tableName);
        }
    }

    private void validateSchemaNotNull(JsonArrowSchema schema, String namespaceName, String tableName) {
        if (schema == null) {
            throw LanceNamespaceException.badRequest((String)String.format("Schema is required in CreateTableRequest: %s.%s", namespaceName, tableName), (String)"BAD_REQUEST", (String)(namespaceName + "." + tableName), (String)"");
        }
    }

    private void safeDropDataset(String location) {
        try {
            Dataset.drop((String)location, this.config.getStorageOptions());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        if (this.glueClient != null) {
            this.glueClient.close();
        }
    }
}

