/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.lancedb.lance.namespace.hive3.Hive3ClientPool;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RetryingHMSHandler;
import org.apache.hadoop.hive.metastore.TSetIpAddressProcessor;
import org.apache.hadoop.hive.metastore.ThreadPool;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.junit.jupiter.api.Assertions;

public class LocalHive3Metastore {
    private static final String DEFAULT_DATABASE_NAME = "default";
    private static final int DEFAULT_POOL_SIZE = 5;
    private static final File HIVE_LOCAL_DIR;
    private static final String DERBY_PATH;
    private HiveConf hiveConf;
    private ExecutorService executorService;
    private TServer server;
    private HiveMetaStore.HMSHandler baseHandler;
    private Hive3ClientPool clientPool;

    private static FileSystem getFs(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get filesystem for " + path, e);
        }
    }

    public void start() {
        this.start(new HiveConf(new Configuration(), LocalHive3Metastore.class), 5);
    }

    public void start(HiveConf conf) {
        this.start(conf, 5);
    }

    public void start(HiveConf conf, int poolSize) {
        this.start(conf, poolSize, false);
    }

    public void start(HiveConf conf, int poolSize, boolean directSql) {
        try {
            TServerSocket socket = new TServerSocket(0);
            int port = socket.getServerSocket().getLocalPort();
            this.initConf(conf, port, directSql);
            this.hiveConf = conf;
            this.server = this.newThriftServer(socket, poolSize, this.hiveConf);
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.submit(() -> this.server.serve());
            System.setProperty(HiveConf.ConfVars.METASTOREURIS.varname, this.hiveConf.getVar(HiveConf.ConfVars.METASTOREURIS));
            this.clientPool = new Hive3ClientPool(1, (Configuration)this.hiveConf);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot start LocalHiveMetastore", e);
        }
    }

    public void stop() throws Exception {
        this.reset();
        if (this.clientPool != null) {
            this.clientPool.close();
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.baseHandler != null) {
            this.baseHandler.shutdown();
        }
        ThreadPool.shutdown();
    }

    public HiveConf hiveConf() {
        return this.hiveConf;
    }

    public String getDatabasePath(String dbName) {
        File dbDir = new File(HIVE_LOCAL_DIR, dbName + ".db");
        return dbDir.getPath();
    }

    public void reset() throws Exception {
        if (this.clientPool != null) {
            List catalogs = (List)this.clientPool.run(client -> client.getCatalogs());
            for (String catalog : catalogs) {
                this.cleanup(catalog);
            }
        }
        Path warehouseRoot = new Path(HIVE_LOCAL_DIR.getAbsolutePath());
        FileSystem fs = LocalHive3Metastore.getFs(warehouseRoot, (Configuration)this.hiveConf);
        for (FileStatus fileStatus : fs.listStatus(warehouseRoot)) {
            if (fileStatus.getPath().getName().equals("derby.log") || fileStatus.getPath().getName().equals("metastore_db")) continue;
            fs.delete(fileStatus.getPath(), true);
        }
    }

    private void cleanup(String catalog) throws Exception {
        if (this.clientPool != null) {
            for (String dbName : (List)this.clientPool.run(client -> client.getAllDatabases(catalog))) {
                for (String tblName : (List)this.clientPool.run(client -> client.getAllTables(catalog, dbName))) {
                    this.clientPool.run(client -> {
                        client.dropTable(catalog, dbName, tblName, true, true, true);
                        return null;
                    });
                }
                if (DEFAULT_DATABASE_NAME.equals(dbName)) continue;
                this.clientPool.run(client -> {
                    client.dropDatabase(catalog, dbName, true, true, true);
                    return null;
                });
            }
        }
        if (!catalog.equals("hive")) {
            this.clientPool.run(client -> {
                client.dropCatalog(catalog);
                return null;
            });
        }
    }

    public Hive3ClientPool clientPool() {
        return this.clientPool;
    }

    private TServer newThriftServer(TServerSocket socket, int poolSize, HiveConf conf) throws Exception {
        HiveConf serverConf = new HiveConf(conf);
        serverConf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.varname, "jdbc:derby:" + DERBY_PATH + ";create=true");
        this.baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", (Configuration)serverConf);
        IHMSHandler handler = RetryingHMSHandler.getProxy((Configuration)serverConf, (IHMSHandler)this.baseHandler, (boolean)false);
        TThreadPoolServer.Args args = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)socket).processor((TProcessor)new TSetIpAddressProcessor((ThriftHiveMetastore.Iface)handler))).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(poolSize).maxWorkerThreads(poolSize);
        return new TThreadPoolServer(args);
    }

    private void initConf(HiveConf conf, int port, boolean directSql) {
        conf.set(HiveConf.ConfVars.METASTOREURIS.varname, "thrift://localhost:" + port);
        conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, "file:" + HIVE_LOCAL_DIR.getAbsolutePath());
        conf.set(HiveConf.ConfVars.METASTORE_TRY_DIRECT_SQL.varname, String.valueOf(directSql));
        conf.set(HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES.varname, "false");
        conf.set("lance.hive.client-pool-size", "2");
        conf.set(HiveConf.ConfVars.HIVE_IN_TEST.varname, HiveConf.ConfVars.HIVE_IN_TEST.getDefaultValue());
        conf.set("datanucleus.connectionPoolingType", "DBCP");
        conf.set(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION.varname, "false");
        conf.set(HiveConf.ConfVars.METASTORE_AUTO_CREATE_ALL.varname, "true");
        try {
            conf.set(HiveConf.ConfVars.METASTORE_SCHEMA_VERIFICATION_RECORD_VERSION.varname, "false");
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        conf.set("datanucleus.schema.autoCreateAll", "true");
        conf.set("datanucleus.autoCreateSchema", "true");
        conf.set("hive.repl.bootstrap.dump.open.txn.timeout", "0");
        conf.set("hive.repl.dump.metadata.only.for.external.table", "false");
        conf.set("hive.in.repl.test", "true");
        conf.set("hive.metastore.event.listeners", "");
        conf.set("hive.metastore.transactional.event.listeners", "");
        conf.set("hive.metastore.event.db.listener.timetolive", "0");
        String tempDir = System.getProperty("java.io.tmpdir");
        conf.set("hive.repl.replica.functions.root.dir", tempDir + "/hive-repl-functions");
        conf.set("hive.repl.rootdir", tempDir + "/hive-repl-root");
        conf.set("hive.repl.cmrootdir", tempDir + "/hive-repl-cm");
        conf.set("hive.metastore.runworker.in", "false");
        conf.set("hive.metastore.task.threads.always", "");
        conf.set("hive.support.concurrency", "false");
        conf.set("hive.txn.manager", "org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager");
        conf.set("hive.compactor.initiator.on", "false");
        conf.set("hive.compactor.worker.threads", "0");
        conf.set("hive.metastore.notifications.add.thrift.objects", "false");
        conf.set("hive.metastore.notification.parameters.exclude.patterns", ".*");
        conf.set("hive.repl.scheduler.enabled", "false");
        conf.set("hive.exec.post.hooks", "");
        conf.set("hive.exec.pre.hooks", "");
        conf.set("hive.exec.failure.hooks", "");
        conf.set("hive.stats.autogather", "false");
        conf.set("hive.stats.column.autogather", "false");
    }

    static {
        try {
            HIVE_LOCAL_DIR = Files.createTempDirectory("hive", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
            DERBY_PATH = new File(HIVE_LOCAL_DIR, "metastore_db").getPath();
            File derbyLogFile = new File(HIVE_LOCAL_DIR, "derby.log");
            System.setProperty("derby.stream.error.file", derbyLogFile.getAbsolutePath());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                Path localDirPath = new Path(HIVE_LOCAL_DIR.getAbsolutePath());
                FileSystem fs = LocalHive3Metastore.getFs(localDirPath, new Configuration());
                String errMsg = "Failed to delete " + localDirPath;
                try {
                    Assertions.assertTrue((boolean)fs.delete(localDirPath, true));
                }
                catch (IOException e) {
                    throw new RuntimeException(errMsg, e);
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to setup local dir for hive metastore", e);
        }
    }
}

