/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lancedb.lance.Dataset;
import com.lancedb.lance.WriteParams;
import com.lancedb.lance.namespace.Configurable;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.ObjectIdentifier;
import com.lancedb.lance.namespace.hive3.Hive3ClientPool;
import com.lancedb.lance.namespace.hive3.Hive3ErrorType;
import com.lancedb.lance.namespace.hive3.Hive3NamespaceConfig;
import com.lancedb.lance.namespace.hive3.Hive3Util;
import com.lancedb.lance.namespace.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.JsonArrowSchema;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.util.ArrowIpcUtil;
import com.lancedb.lance.namespace.util.CommonUtil;
import com.lancedb.lance.namespace.util.JsonArrowSchemaConverter;
import com.lancedb.lance.namespace.util.PageUtil;
import com.lancedb.lance.namespace.util.ValidationUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hive3Namespace
implements LanceNamespace,
Configurable<Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(Hive3Namespace.class);
    private Hive3ClientPool clientPool;
    private Configuration hadoopConf;
    private BufferAllocator allocator;
    private Hive3NamespaceConfig config;

    public void initialize(Map<String, String> configProperties, BufferAllocator allocator) {
        this.allocator = allocator;
        if (this.hadoopConf == null) {
            LOG.warn("Hadoop configuration not set, using the default configuration.");
            this.hadoopConf = new Configuration();
        }
        this.config = new Hive3NamespaceConfig(configProperties);
        this.clientPool = new Hive3ClientPool(this.config.getClientPoolSize(), this.hadoopConf);
    }

    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        ObjectIdentifier nsId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((nsId.levels() <= 2 ? 1 : 0) != 0, (String)"Expect a 2-level namespace but get %s", (Object[])new Object[]{nsId});
        List<String> namespaces = this.doListNamespaces(nsId);
        Collections.sort(namespaces);
        PageUtil.Page page = PageUtil.splitPage(namespaces, (String)request.getPageToken(), (int)PageUtil.normalizePageSize((Integer)request.getLimit()));
        ListNamespacesResponse response = new ListNamespacesResponse();
        response.setNamespaces((Set)Sets.newHashSet((Iterable)page.items()));
        response.setPageToken(page.nextPageToken());
        return response;
    }

    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        ObjectIdentifier id = ObjectIdentifier.of((List)request.getId());
        CreateNamespaceRequest.ModeEnum mode = request.getMode();
        Map properties = request.getProperties();
        ValidationUtil.checkArgument((!id.isRoot() && id.levels() <= 2 ? 1 : 0) != 0, (String)"Expect a 3-level namespace but get %s", (Object[])new Object[]{id});
        this.doCreateNamespace(id, mode, properties);
        CreateNamespaceResponse response = new CreateNamespaceResponse();
        response.setProperties(properties);
        return response;
    }

    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest request) {
        ObjectIdentifier id = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((!id.isRoot() && id.levels() <= 2 ? 1 : 0) != 0, (String)"Expect a 2-level namespace but get %s", (Object[])new Object[]{id});
        DescribeNamespaceResponse response = new DescribeNamespaceResponse();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (id.levels() == 1) {
            String catalog = id.levelAtListPos(0).toLowerCase();
            Catalog catalogObj = Hive3Util.getCatalogOrNull(this.clientPool, catalog);
            if (catalogObj == null) {
                throw LanceNamespaceException.notFound((String)String.format("Namespace does not exist: %s", id.stringStyleId()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
            }
            if (catalogObj.getDescription() != null) {
                properties.put("description", catalogObj.getDescription());
            }
            if (catalogObj.getLocationUri() != null) {
                properties.put("catalog.location.uri", catalogObj.getLocationUri());
            }
        } else {
            String db;
            String catalog = id.levelAtListPos(0).toLowerCase();
            Database database = Hive3Util.getDatabaseOrNull(this.clientPool, catalog, db = id.levelAtListPos(1).toLowerCase());
            if (database == null) {
                throw LanceNamespaceException.notFound((String)String.format("Namespace does not exist: %s", id.stringStyleId()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
            }
            if (database.getDescription() != null) {
                properties.put("database.description", database.getDescription());
            }
            if (database.getLocationUri() != null) {
                properties.put("database.location-uri", database.getLocationUri());
            }
            if (database.getOwnerName() != null) {
                properties.put("database.owner", database.getOwnerName());
            }
            if (database.getOwnerType() != null) {
                properties.put("database.owner-type", database.getOwnerType().name());
            }
            if (database.getParameters() != null) {
                properties.putAll(database.getParameters());
            }
        }
        response.setProperties(properties);
        return response;
    }

    public void namespaceExists(NamespaceExistsRequest request) {
        String db;
        Database database;
        String catalog;
        Catalog catalogObj;
        ObjectIdentifier id = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((!id.isRoot() && id.levels() <= 2 ? 1 : 0) != 0, (String)"Expect a 2-level namespace but get %s", (Object[])new Object[]{id});
        if (id.levels() == 1 ? (catalogObj = Hive3Util.getCatalogOrNull(this.clientPool, catalog = id.levelAtListPos(0).toLowerCase())) == null : (database = Hive3Util.getDatabaseOrNull(this.clientPool, catalog = id.levelAtListPos(0).toLowerCase(), db = id.levelAtListPos(1).toLowerCase())) == null) {
            throw LanceNamespaceException.notFound((String)String.format("Namespace does not exist: %s", id.stringStyleId()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public DropNamespaceResponse dropNamespace(DropNamespaceRequest request) {
        ObjectIdentifier id = ObjectIdentifier.of((List)request.getId());
        DropNamespaceRequest.ModeEnum mode = request.getMode();
        DropNamespaceRequest.BehaviorEnum behavior = request.getBehavior();
        ValidationUtil.checkArgument((!id.isRoot() && id.levels() <= 2 ? 1 : 0) != 0, (String)"Expect a 2-level namespace but get %s", (Object[])new Object[]{id});
        if (mode == null) {
            mode = DropNamespaceRequest.ModeEnum.FAIL;
        }
        if (behavior == null) {
            behavior = DropNamespaceRequest.BehaviorEnum.RESTRICT;
        }
        Map<String, String> properties = this.doDropNamespace(id, mode, behavior);
        DropNamespaceResponse response = new DropNamespaceResponse();
        response.setProperties(properties);
        return response;
    }

    public void tableExists(TableExistsRequest request) {
        ObjectIdentifier tableId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((tableId.levels() == 3 ? 1 : 0) != 0, (String)"Expect 3-level table identifier but get %s", (Object[])new Object[]{tableId});
        String catalog = tableId.levelAtListPos(0).toLowerCase();
        String db = tableId.levelAtListPos(1).toLowerCase();
        String table = tableId.levelAtListPos(2).toLowerCase();
        Optional<Table> hmsTable = Hive3Util.getTable(this.clientPool, catalog, db, table);
        if (!hmsTable.isPresent()) {
            throw LanceNamespaceException.notFound((String)String.format("Table does not exist: %s", tableId.stringStyleId()), (String)Hive3ErrorType.TableNotFound.getType(), (String)tableId.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
        Hive3Util.validateLanceTable(hmsTable.get());
    }

    public ListTablesResponse listTables(ListTablesRequest request) {
        ObjectIdentifier nsId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((!nsId.isRoot() && nsId.levels() == 2 ? 1 : 0) != 0, (String)"Expect a 2-level namespace but get %s", (Object[])new Object[]{nsId});
        String catalog = nsId.levelAtListPos(0).toLowerCase();
        String db = nsId.levelAtListPos(1).toLowerCase();
        List<String> tables = this.doListTables(catalog, db);
        Collections.sort(tables);
        PageUtil.Page page = PageUtil.splitPage(tables, (String)request.getPageToken(), (int)PageUtil.normalizePageSize((Integer)request.getLimit()));
        ListTablesResponse response = new ListTablesResponse();
        response.setTables((Set)Sets.newHashSet((Iterable)page.items()));
        response.setPageToken(page.nextPageToken());
        return response;
    }

    public DescribeTableResponse describeTable(DescribeTableRequest request) {
        ObjectIdentifier tableId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((tableId.levels() == 3 ? 1 : 0) != 0, (String)"Expect 3-level table identifier but get %s", (Object[])new Object[]{tableId});
        Optional<String> location = this.doDescribeTable(tableId);
        if (!location.isPresent()) {
            throw LanceNamespaceException.notFound((String)String.format("Table does not exist: %s", tableId.stringStyleId()), (String)Hive3ErrorType.TableNotFound.getType(), (String)tableId.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
        DescribeTableResponse response = new DescribeTableResponse();
        response.setLocation(location.get());
        return response;
    }

    public CreateTableResponse createTable(CreateTableRequest request, byte[] requestData) {
        JsonArrowSchema jsonSchema;
        ValidationUtil.checkNotNull((Object)requestData, (String)"Request data (Arrow IPC stream) is required for createTable", (Object[])new Object[0]);
        ValidationUtil.checkArgument((requestData.length > 0 ? 1 : 0) != 0, (String)"Request data (Arrow IPC stream) cannot be empty", (Object[])new Object[0]);
        ObjectIdentifier tableId = ObjectIdentifier.of((List)request.getId());
        try {
            jsonSchema = ArrowIpcUtil.extractSchemaFromIpc((byte[])requestData);
        }
        catch (IOException e) {
            throw LanceNamespaceException.badRequest((String)("Invalid Arrow IPC stream: " + e.getMessage()), (String)"INVALID_ARROW_IPC", (String)tableId.stringStyleId(), (String)"Failed to extract schema from Arrow IPC stream");
        }
        Schema schema = JsonArrowSchemaConverter.convertToArrowSchema((JsonArrowSchema)jsonSchema);
        ValidationUtil.checkArgument((tableId.levels() == 3 ? 1 : 0) != 0, (String)"Expect 3-level table identifier but get %s", (Object[])new Object[]{tableId});
        String location = request.getLocation();
        if (location == null || location.isEmpty()) {
            location = this.getDefaultTableLocation(tableId.levelAtListPos(1), tableId.levelAtListPos(2));
        }
        this.doCreateTable(tableId, schema, location, request.getProperties(), requestData);
        CreateTableResponse response = new CreateTableResponse();
        response.setLocation(location);
        response.setVersion(Long.valueOf(1L));
        return response;
    }

    public CreateEmptyTableResponse createEmptyTable(CreateEmptyTableRequest request) {
        ObjectIdentifier tableId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((tableId.levels() == 3 ? 1 : 0) != 0, (String)"Expect 3-level table identifier but get %s", (Object[])new Object[]{tableId});
        String location = request.getLocation();
        if (location == null || location.isEmpty()) {
            location = this.getDefaultTableLocation(tableId.levelAtListPos(1), tableId.levelAtListPos(2));
        }
        this.doCreateTable(tableId, null, location, request.getProperties(), null);
        CreateEmptyTableResponse response = new CreateEmptyTableResponse();
        response.setLocation(location);
        return response;
    }

    public DropTableResponse dropTable(DropTableRequest request) {
        ObjectIdentifier tableId = ObjectIdentifier.of((List)request.getId());
        ValidationUtil.checkArgument((tableId.levels() == 3 ? 1 : 0) != 0, (String)"Expect 3-level table identifier but get %s", (Object[])new Object[]{tableId});
        String location = this.doDropTable(tableId);
        DropTableResponse response = new DropTableResponse();
        response.setLocation(location);
        response.setId(request.getId());
        return response;
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = conf;
    }

    protected List<String> doListNamespaces(ObjectIdentifier parent) {
        try {
            if (parent.isRoot()) {
                return (List)this.clientPool.run(IMetaStoreClient::getCatalogs);
            }
            if (parent.levels() == 1) {
                return (List)this.clientPool.run(client -> client.getAllDatabases(parent.levelAtListPos(0)));
            }
            return Lists.newArrayList();
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            throw LanceNamespaceException.serviceUnavailable((String)("Failed operation: " + errorMessage), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    protected void doCreateNamespace(ObjectIdentifier id, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) {
        try {
            if (id.levels() == 1) {
                String name = id.levelAtListPos(0).toLowerCase();
                this.createCatalog(name, mode, properties);
            } else {
                String catalog = id.levelAtListPos(0).toLowerCase();
                String db = id.levelAtListPos(1).toLowerCase();
                this.createDatabase(catalog, db, mode, properties);
            }
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            throw LanceNamespaceException.serviceUnavailable((String)("Failed operation: " + errorMessage), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    private void createCatalog(String catalogName, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) throws TException, InterruptedException {
        String description;
        String locationUri;
        Catalog existingCatalog = Hive3Util.getCatalogOrNull(this.clientPool, catalogName);
        if (existingCatalog != null) {
            switch (mode) {
                case CREATE: {
                    throw LanceNamespaceException.conflict((String)String.format("Catalog %s already exists", catalogName), (String)Hive3ErrorType.DatabaseAlreadyExist.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
                }
                case EXIST_OK: {
                    return;
                }
                case OVERWRITE: {
                    this.clientPool.run(client -> {
                        client.dropCatalog(catalogName);
                        return null;
                    });
                }
            }
        }
        Catalog catalog = new Catalog();
        catalog.setName(catalogName);
        String string = locationUri = properties != null ? properties.get("catalog.location.uri") : null;
        if (locationUri == null) {
            locationUri = this.hadoopConf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "/" + catalogName;
        }
        catalog.setLocationUri(locationUri);
        String string2 = description = properties != null ? properties.get("description") : null;
        if (description != null) {
            catalog.setDescription(description);
        } else {
            catalog.setDescription("Lance catalog: " + catalogName);
        }
        this.clientPool.run(client -> {
            client.createCatalog(catalog);
            return null;
        });
    }

    private void createDatabase(String catalogName, String dbName, CreateNamespaceRequest.ModeEnum mode, Map<String, String> properties) throws TException, InterruptedException {
        HashMap<String, String> dbProperties;
        Catalog catalog = Hive3Util.getCatalogOrThrowNotFoundException(this.clientPool, catalogName);
        Database oldDb = Hive3Util.getDatabaseOrNull(this.clientPool, catalogName, dbName);
        if (oldDb != null) {
            switch (mode) {
                case CREATE: {
                    throw LanceNamespaceException.conflict((String)String.format("Database %s.%s already exist", catalogName, dbName), (String)Hive3ErrorType.DatabaseAlreadyExist.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
                }
                case EXIST_OK: {
                    return;
                }
                case OVERWRITE: {
                    this.clientPool.run(client -> {
                        client.dropDatabase(catalogName, dbName, false, true, false);
                        return null;
                    });
                }
            }
        }
        if (!(dbProperties = new HashMap<String, String>(properties != null ? properties : new HashMap())).containsKey("database.location-uri")) {
            String dbLocation = String.format("%s/%s", this.config.getRoot(), dbName);
            dbProperties.put("database.location-uri", dbLocation);
        }
        Database database = new Database();
        database.setCatalogName(catalogName);
        database.setName(dbName);
        Hive3Util.setDatabaseProperties(database, () -> catalog.getLocationUri(), dbName, dbProperties);
        this.clientPool.run(client -> {
            client.createDatabase(database);
            return null;
        });
    }

    protected Optional<String> doDescribeTable(ObjectIdentifier id) {
        String table;
        String db;
        String catalog = id.levelAtListPos(0).toLowerCase();
        Optional<Table> hmsTable = Hive3Util.getTable(this.clientPool, catalog, db = id.levelAtListPos(1).toLowerCase(), table = id.levelAtListPos(2).toLowerCase());
        if (!hmsTable.isPresent()) {
            return Optional.empty();
        }
        Hive3Util.validateLanceTable(hmsTable.get());
        return Optional.of(hmsTable.get().getSd().getLocation());
    }

    protected void doCreateTable(ObjectIdentifier id, Schema schema, String location, Map<String, String> properties, byte[] data) {
        if (properties != null && "impl".equalsIgnoreCase(properties.get("managed_by"))) {
            throw new UnsupportedOperationException("managed_by=impl is not supported yet");
        }
        String catalog = id.levelAtListPos(0).toLowerCase();
        String db = id.levelAtListPos(1).toLowerCase();
        String tableName = id.levelAtListPos(2).toLowerCase();
        try {
            Optional<Table> existing = Hive3Util.getTable(this.clientPool, catalog, db, tableName);
            if (existing.isPresent()) {
                throw LanceNamespaceException.conflict((String)String.format("Table %s.%s.%s already exists", catalog, db, tableName), (String)Hive3ErrorType.TableAlreadyExists.getType(), (String)String.format("%s.%s.%s", catalog, db, tableName), (String)CommonUtil.formatCurrentStackTrace());
            }
            Table table = new Table();
            table.setCatName(catalog);
            table.setDbName(db);
            table.setTableName(tableName);
            table.setTableType("EXTERNAL_TABLE");
            table.setPartitionKeys((List)Lists.newArrayList());
            StorageDescriptor sd = new StorageDescriptor();
            sd.setLocation(location);
            sd.setCols((List)Lists.newArrayList());
            sd.setInputFormat("com.lancedb.lance.mapred.LanceInputFormat");
            sd.setOutputFormat("com.lancedb.lance.mapred.LanceOutputFormat");
            sd.setSerdeInfo(new SerDeInfo());
            table.setSd(sd);
            Map<String, String> params = Hive3Util.createLanceTableParams(properties);
            table.setParameters(params);
            this.clientPool.run(client -> {
                client.createTable(table);
                return null;
            });
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serverError((String)("Fail to create table: " + e.getMessage()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
        if (data != null && data.length > 0) {
            WriteParams writeParams = new WriteParams.Builder().withMode(WriteParams.WriteMode.CREATE).withStorageOptions(this.config.getStorageOptions()).build();
            Dataset.create((BufferAllocator)this.allocator, (String)location, (Schema)schema, (WriteParams)writeParams);
        }
    }

    protected List<String> doListTables(String catalog, String db) {
        try {
            Catalog catalogObj = Hive3Util.getCatalogOrNull(this.clientPool, catalog);
            if (catalogObj == null) {
                throw LanceNamespaceException.notFound((String)String.format("Catalog %s doesn't exist", catalog), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)catalog, (String)CommonUtil.formatCurrentStackTrace());
            }
            Database database = Hive3Util.getDatabaseOrNull(this.clientPool, catalog, db);
            if (database == null) {
                throw LanceNamespaceException.notFound((String)String.format("Database %s.%s doesn't exist", catalog, db), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)String.format("%s.%s", catalog, db), (String)CommonUtil.formatCurrentStackTrace());
            }
            List allTables = (List)this.clientPool.run(client -> client.getAllTables(catalog, db));
            ArrayList lanceTables = Lists.newArrayList();
            for (String tableName : allTables) {
                try {
                    Map params;
                    Optional<Table> table = Hive3Util.getTable(this.clientPool, catalog, db, tableName);
                    if (!table.isPresent() || (params = table.get().getParameters()) == null || !"lance".equalsIgnoreCase((String)params.get("table_type"))) continue;
                    lanceTables.add(tableName);
                }
                catch (Exception e) {
                    LOG.warn("Failed to validate table {}.{}.{}: {}", new Object[]{catalog, db, tableName, e.getMessage()});
                }
            }
            return lanceTables;
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            throw LanceNamespaceException.serviceUnavailable((String)("Failed to list tables: " + errorMessage), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    protected String doDropTable(ObjectIdentifier id) {
        String catalog = id.levelAtListPos(0).toLowerCase();
        String db = id.levelAtListPos(1).toLowerCase();
        String tableName = id.levelAtListPos(2).toLowerCase();
        try {
            Optional<Table> hmsTable = Hive3Util.getTable(this.clientPool, catalog, db, tableName);
            if (!hmsTable.isPresent()) {
                throw LanceNamespaceException.notFound((String)String.format("Table %s.%s.%s does not exist", catalog, db, tableName), (String)Hive3ErrorType.TableNotFound.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
            }
            Hive3Util.validateLanceTable(hmsTable.get());
            String location = hmsTable.get().getSd().getLocation();
            this.clientPool.run(client -> {
                client.dropTable(catalog, db, tableName, false, true);
                return null;
            });
            return location;
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            throw LanceNamespaceException.serviceUnavailable((String)("Failed to drop table: " + errorMessage), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    protected Map<String, String> doDropNamespace(ObjectIdentifier id, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) {
        try {
            if (id.levels() == 1) {
                return this.doDropCatalog(id.levelAtListPos(0).toLowerCase(), mode, behavior);
            }
            return this.doDropDatabase(id.levelAtListPos(0).toLowerCase(), id.levelAtListPos(1).toLowerCase(), mode, behavior);
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            String errorMessage = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            throw LanceNamespaceException.serviceUnavailable((String)("Failed to drop namespace: " + errorMessage), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)id.stringStyleId(), (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    private Map<String, String> doDropCatalog(String catalog, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) throws TException, InterruptedException {
        Catalog catalogObj = Hive3Util.getCatalogOrNull(this.clientPool, catalog);
        if (catalogObj == null) {
            if (mode == DropNamespaceRequest.ModeEnum.SKIP) {
                return new HashMap<String, String>();
            }
            throw LanceNamespaceException.notFound((String)String.format("Catalog %s doesn't exist", catalog), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)catalog, (String)CommonUtil.formatCurrentStackTrace());
        }
        List databases = (List)this.clientPool.run(client -> client.getAllDatabases(catalog));
        if (!databases.isEmpty()) {
            if (behavior == DropNamespaceRequest.BehaviorEnum.RESTRICT) {
                throw LanceNamespaceException.badRequest((String)String.format("Catalog %s is not empty. Contains %d databases: %s", catalog, databases.size(), databases), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)catalog, (String)CommonUtil.formatCurrentStackTrace());
            }
            if (behavior == DropNamespaceRequest.BehaviorEnum.CASCADE) {
                for (String dbName : databases) {
                    try {
                        this.doDropDatabase(catalog, dbName, DropNamespaceRequest.ModeEnum.FAIL, DropNamespaceRequest.BehaviorEnum.CASCADE);
                        LOG.info("Dropped database {}.{} during CASCADE operation", (Object)catalog, (Object)dbName);
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to drop database {}.{}: {}", new Object[]{catalog, dbName, e.getMessage()});
                        throw LanceNamespaceException.serviceUnavailable((String)String.format("Failed to drop database %s.%s during CASCADE operation: %s", catalog, dbName, e.getMessage()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)String.format("%s.%s", catalog, dbName), (String)CommonUtil.formatCurrentStackTrace());
                    }
                }
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (catalogObj.getDescription() != null) {
            properties.put("description", catalogObj.getDescription());
        }
        if (catalogObj.getLocationUri() != null) {
            properties.put("catalog.location.uri", catalogObj.getLocationUri());
        }
        this.clientPool.run(client -> {
            client.dropCatalog(catalog);
            return null;
        });
        LOG.info("Successfully dropped catalog: {}", (Object)catalog);
        return properties;
    }

    private Map<String, String> doDropDatabase(String catalog, String db, DropNamespaceRequest.ModeEnum mode, DropNamespaceRequest.BehaviorEnum behavior) throws TException, InterruptedException {
        Database database = Hive3Util.getDatabaseOrNull(this.clientPool, catalog, db);
        if (database == null) {
            if (mode == DropNamespaceRequest.ModeEnum.SKIP) {
                return new HashMap<String, String>();
            }
            throw LanceNamespaceException.notFound((String)String.format("Database %s.%s doesn't exist", catalog, db), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)String.format("%s.%s", catalog, db), (String)CommonUtil.formatCurrentStackTrace());
        }
        List<String> tables = this.doListTables(catalog, db);
        if (!tables.isEmpty()) {
            if (behavior == DropNamespaceRequest.BehaviorEnum.RESTRICT) {
                throw LanceNamespaceException.badRequest((String)String.format("Database %s.%s is not empty. Contains %d tables: %s", catalog, db, tables.size(), tables), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)String.format("%s.%s", catalog, db), (String)CommonUtil.formatCurrentStackTrace());
            }
            if (behavior == DropNamespaceRequest.BehaviorEnum.CASCADE) {
                for (String tableName : tables) {
                    try {
                        ObjectIdentifier tableId = ObjectIdentifier.of((List)Lists.newArrayList((Object[])new String[]{catalog, db, tableName}));
                        this.doDropTable(tableId);
                        LOG.info("Dropped table {}.{}.{} during CASCADE operation", new Object[]{catalog, db, tableName});
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to drop table {}.{}.{}: {}", new Object[]{catalog, db, tableName, e.getMessage()});
                        throw LanceNamespaceException.serviceUnavailable((String)String.format("Failed to drop table %s.%s.%s during CASCADE operation: %s", catalog, db, tableName, e.getMessage()), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)String.format("%s.%s.%s", catalog, db, tableName), (String)CommonUtil.formatCurrentStackTrace());
                    }
                }
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (database.getDescription() != null) {
            properties.put("database.description", database.getDescription());
        }
        if (database.getLocationUri() != null) {
            properties.put("database.location-uri", database.getLocationUri());
        }
        if (database.getOwnerName() != null) {
            properties.put("database.owner", database.getOwnerName());
        }
        if (database.getOwnerType() != null) {
            properties.put("database.owner-type", database.getOwnerType().name());
        }
        if (database.getParameters() != null) {
            properties.putAll(database.getParameters());
        }
        this.clientPool.run(client -> {
            client.dropDatabase(catalog, db, false, true, false);
            return null;
        });
        LOG.info("Successfully dropped database: {}.{}", (Object)catalog, (Object)db);
        return properties;
    }

    private String getDefaultTableLocation(String namespaceName, String tableName) {
        try {
            Database db = Hive3Util.getDatabaseOrNull(this.clientPool, namespaceName.toLowerCase());
            if (db != null && db.getLocationUri() != null && !db.getLocationUri().isEmpty()) {
                String dbLocation = db.getLocationUri();
                if (!dbLocation.endsWith("/")) {
                    dbLocation = dbLocation + "/";
                }
                return dbLocation + tableName.toLowerCase() + ".lance";
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to get database location for {}, using root config", (Object)namespaceName, (Object)e);
        }
        return String.format("%s/%s/%s.lance", this.config.getRoot(), namespaceName.toLowerCase(), tableName.toLowerCase());
    }
}

