/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.lancedb.lance.namespace.util.OpenDalUtil;
import com.lancedb.lance.namespace.util.PropertyUtil;
import java.util.Map;

public class Hive3NamespaceConfig {
    public static final String CATALOG_NAME = "hive";
    public static final String DATABASE_DESCRIPTION = "database.description";
    public static final String DATABASE_LOCATION_URI = "database.location-uri";
    public static final String DATABASE_OWNER = "database.owner";
    public static final String DATABASE_OWNER_TYPE = "database.owner-type";
    public static final String CLIENT_POOL_SIZE = "client.pool-size";
    public static final int CLIENT_POOL_SIZE_DEFAULT = 3;
    public static final String STORAGE_OPTIONS_PREFIX = "storage.";
    public static final String ROOT = "root";
    public static final String ROOT_DEFAULT = System.getProperty("user.dir");
    private final int clientPoolSize;
    private final Map<String, String> storageOptions;
    private final String root;

    public Hive3NamespaceConfig(Map<String, String> properties) {
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, (String)CLIENT_POOL_SIZE, (int)3);
        this.storageOptions = PropertyUtil.propertiesWithPrefix(properties, (String)STORAGE_OPTIONS_PREFIX);
        this.root = OpenDalUtil.stripTrailingSlash((String)PropertyUtil.propertyAsString(properties, (String)ROOT, (String)ROOT_DEFAULT));
    }

    public int getClientPoolSize() {
        return this.clientPoolSize;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public String getRoot() {
        return this.root;
    }
}

