/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.lancedb.lance.namespace.hive3.Hive3MetaException;
import com.lancedb.lance.namespace.util.ClientPoolImpl;
import com.lancedb.lance.namespace.util.DynMethods;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransportException;

public class Hive3ClientPool
extends ClientPoolImpl<IMetaStoreClient, TException> {
    private static final DynMethods.StaticMethod GET_CLIENT = DynMethods.builder((String)"getProxy").impl(RetryingMetaStoreClient.class, new Class[]{Configuration.class, HiveMetaHookLoader.class, String.class}).buildStatic();
    private final HiveConf hiveConf;

    public Hive3ClientPool(int poolSize, Configuration conf) {
        super(poolSize, TTransportException.class, false);
        this.hiveConf = new HiveConf(conf, Hive3ClientPool.class);
        this.hiveConf.addResource(conf);
    }

    protected IMetaStoreClient newClient() {
        try {
            try {
                return (IMetaStoreClient)GET_CLIENT.invoke(new Object[]{this.hiveConf, tbl -> null, HiveMetaStoreClient.class.getName()});
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof MetaException) {
                    throw (MetaException)e.getCause();
                }
                throw e;
            }
        }
        catch (MetaException e) {
            throw new Hive3MetaException(e, "Failed to connect to Hive 3.x Metastore", new Object[0]);
        }
        catch (Throwable t) {
            if (t.getMessage() != null && t.getMessage().contains("Another instance of Derby may have already booted")) {
                throw new Hive3MetaException(t, "Failed to start an embedded metastore because embedded Derby supports only one client at a time. To fix this, use a metastore that supports multiple clients.", new Object[0]);
            }
            throw new Hive3MetaException(t, "Failed to connect to Hive 3.x Metastore", new Object[0]);
        }
    }

    protected IMetaStoreClient reconnect(IMetaStoreClient client) {
        try {
            client.close();
            client.reconnect();
        }
        catch (MetaException e) {
            throw new Hive3MetaException(e, "Failed to reconnect to Hive 3.x Metastore", new Object[0]);
        }
        return client;
    }

    protected boolean isConnectionException(Exception e) {
        return super.isConnectionException(e) || e instanceof MetaException && e.getMessage().contains("Got exception: org.apache.thrift.transport.TTransportException");
    }

    protected void close(IMetaStoreClient client) {
        client.close();
    }
}

