/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.google.common.collect.Maps;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.LanceNamespaces;
import com.lancedb.lance.namespace.TestHelper;
import com.lancedb.lance.namespace.hive3.LocalHive3Metastore;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestHive3Namespace {
    private static BufferAllocator allocator;
    private static LocalHive3Metastore metastore;
    private static String tmpDirBase;
    private static LanceNamespace namespace;

    @BeforeAll
    public static void setup() throws IOException {
        allocator = new RootAllocator(Long.MAX_VALUE);
        metastore = new LocalHive3Metastore();
        metastore.start();
        File file = Files.createTempDirectory("TestHive3Namespace", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"))).toFile();
        tmpDirBase = file.getAbsolutePath();
        HiveConf hiveConf = metastore.hiveConf();
        namespace = LanceNamespaces.connect((String)"hive3", (Map)Maps.newHashMap(), (Object)hiveConf, (BufferAllocator)allocator);
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        HashMap properties = Maps.newHashMap();
        properties.put("catalog.location.uri", "file://" + tmpDirBase + "/test_catalog");
        nsRequest.setProperties((Map)properties);
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(nsRequest);
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        namespace.createNamespace(nsRequest);
    }

    @AfterAll
    public static void teardown() throws Exception {
        if (allocator != null) {
            allocator.close();
        }
        if (metastore != null) {
            metastore.stop();
        }
        if (tmpDirBase != null) {
            File file = new File(tmpDirBase);
            file.delete();
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        metastore.reset();
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        HashMap properties = Maps.newHashMap();
        properties.put("catalog.location.uri", "file://" + tmpDirBase + "/test_catalog");
        nsRequest.setProperties((Map)properties);
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(nsRequest);
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        namespace.createNamespace(nsRequest);
    }

    @Disabled(value="Need to figure out the proper interface")
    @Test
    public void testCreateTable() throws IOException {
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        request.setLocation(tmpDirBase + "/test_catalog/test_db/test_table.lance");
        request.setSchema(TestHelper.createTestSchema());
        HashMap properties = Maps.newHashMap();
        properties.put("custom_prop", "custom_value");
        request.setProperties((Map)properties);
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        CreateTableResponse response = namespace.createTable(request, testData);
        Assertions.assertEquals((Object)request.getLocation(), (Object)response.getLocation());
        Assertions.assertEquals((long)1L, (Long)response.getVersion());
    }

    @Test
    public void testCreateTableAlreadyExists() throws IOException {
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        request.setLocation(tmpDirBase + "/test_catalog/test_db/test_table.lance");
        request.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(request, testData);
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.createTable(request, testData));
        Assertions.assertTrue((boolean)error.getMessage().contains("Table test_catalog.test_db.test_table already exists"));
    }

    @Test
    public void testCreateTableManagedByImpl() throws IOException {
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "impl_table"}));
        request.setLocation(tmpDirBase + "/test_catalog/test_db/impl_table.lance");
        request.setSchema(TestHelper.createTestSchema());
        HashMap properties = Maps.newHashMap();
        properties.put("managed_by", "impl");
        request.setProperties((Map)properties);
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        Exception error = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> namespace.createTable(request, testData));
        Assertions.assertTrue((boolean)error.getMessage().contains("managed_by=impl is not supported yet"));
    }

    @Test
    public void testCreateTableWithoutData() throws IOException {
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "no_data_table"}));
        request.setLocation(tmpDirBase + "/test_catalog/test_db/no_data_table.lance");
        request.setSchema(TestHelper.createTestSchema());
        byte[] emptyData = TestHelper.createEmptyArrowData((BufferAllocator)allocator);
        CreateTableResponse response = namespace.createTable(request, emptyData);
        Assertions.assertEquals((Object)request.getLocation(), (Object)response.getLocation());
    }

    @Test
    public void testDescribeTable() throws IOException {
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog/test_db/test_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        DescribeTableRequest request = new DescribeTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        DescribeTableResponse response = namespace.describeTable(request);
        Assertions.assertEquals((Object)("file:" + tmpDirBase + "/test_catalog/test_db/test_table.lance"), (Object)response.getLocation());
    }

    @Test
    public void testDescribeNonExistentTable() {
        DescribeTableRequest request = new DescribeTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "non_existent"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.describeTable(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Table does not exist"));
    }

    @Test
    public void testDropTable() throws IOException {
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog/test_db/test_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        DropTableRequest request = new DropTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        DropTableResponse response = namespace.dropTable(request);
        Assertions.assertEquals((Object)("file:" + tmpDirBase + "/test_catalog/test_db/test_table.lance"), (Object)response.getLocation());
        Assertions.assertEquals((Object)request.getId(), (Object)response.getId());
        DescribeTableRequest descRequest = new DescribeTableRequest();
        descRequest.setId(request.getId());
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.describeTable(descRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Table does not exist"));
    }

    @Test
    public void testDropNonExistentTable() {
        DropTableRequest request = new DropTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "non_existent"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.dropTable(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Table test_catalog.test_db.non_existent does not exist"));
    }

    @Test
    public void testCreateTableWithDefaultLocationFromRoot() throws IOException {
        HashMap properties = Maps.newHashMap();
        properties.put("root", tmpDirBase);
        HiveConf hiveConf = metastore.hiveConf();
        LanceNamespace customNamespace = LanceNamespaces.connect((String)"hive3", (Map)properties, (Object)hiveConf, (BufferAllocator)allocator);
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db_root"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        customNamespace.createNamespace(nsRequest);
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db_root", "test_table"}));
        request.setSchema(TestHelper.createTestSchema());
        CreateTableResponse response = customNamespace.createTable(request, null);
        String expectedLocation = tmpDirBase + "/test_db_root/test_table.lance";
        Assertions.assertTrue((response.getLocation().equals(expectedLocation) || response.getLocation().equals("file:" + expectedLocation) ? 1 : 0) != 0, (String)("Expected location (with or without file: prefix): " + expectedLocation + " but got: " + response.getLocation()));
        Assertions.assertEquals((long)1L, (Long)response.getVersion());
    }

    @Test
    public void testCreateTableWithExplicitDatabaseLocation() throws IOException {
        HashMap properties = Maps.newHashMap();
        properties.put("root", tmpDirBase);
        HiveConf hiveConf = metastore.hiveConf();
        LanceNamespace customNamespace = LanceNamespaces.connect((String)"hive3", (Map)properties, (Object)hiveConf, (BufferAllocator)allocator);
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db_with_location"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        String databaseLocation = tmpDirBase + "/custom_db_location";
        HashMap dbProperties = Maps.newHashMap();
        dbProperties.put("database.location-uri", databaseLocation);
        nsRequest.setProperties((Map)dbProperties);
        customNamespace.createNamespace(nsRequest);
        CreateTableRequest request = new CreateTableRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db_with_location", "test_table"}));
        request.setSchema(TestHelper.createTestSchema());
        CreateTableResponse response = customNamespace.createTable(request, null);
        Assertions.assertTrue((response.getLocation().contains("custom_db_location/test_table.lance") || response.getLocation().contains("test_db_with_location/test_table.lance") ? 1 : 0) != 0, (String)("Expected either custom database location or root fallback but got: " + response.getLocation()));
        Assertions.assertEquals((long)1L, (Long)response.getVersion());
    }

    @Test
    public void testDescribeNamespaceCatalog() {
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog"}));
        DescribeNamespaceResponse response = namespace.describeNamespace(request);
        Assertions.assertEquals((Object)"Lance catalog: test_catalog", response.getProperties().get("description"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("catalog.location.uri"));
    }

    @Test
    public void testDescribeNamespaceDatabase() {
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        DescribeNamespaceResponse response = namespace.describeNamespace(request);
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.location-uri"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.owner"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.owner-type"));
    }

    @Test
    public void testDescribeNamespaceDatabaseWithCustomProperties() {
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "custom_db"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        HashMap properties = Maps.newHashMap();
        properties.put("database.description", "Custom database description");
        properties.put("custom_param", "custom_value");
        nsRequest.setProperties((Map)properties);
        namespace.createNamespace(nsRequest);
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "custom_db"}));
        DescribeNamespaceResponse response = namespace.describeNamespace(request);
        Assertions.assertEquals((Object)"Custom database description", response.getProperties().get("database.description"));
        Assertions.assertEquals((Object)"custom_value", response.getProperties().get("custom_param"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.location-uri"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.owner"));
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.owner-type"));
    }

    @Test
    public void testDescribeNonExistentCatalog() {
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Lists.list((Object[])new String[]{"non_existent_catalog"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.describeNamespace(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testDescribeNonExistentDatabase() {
        DescribeNamespaceRequest request = new DescribeNamespaceRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "non_existent_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.describeNamespace(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testNamespaceExistsCatalog() {
        NamespaceExistsRequest request = new NamespaceExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog"}));
        namespace.namespaceExists(request);
    }

    @Test
    public void testNamespaceExistsDatabase() {
        NamespaceExistsRequest request = new NamespaceExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        namespace.namespaceExists(request);
    }

    @Test
    public void testNamespaceExistsNonExistentCatalog() {
        NamespaceExistsRequest request = new NamespaceExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"non_existent_catalog"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testNamespaceExistsNonExistentDatabase() {
        NamespaceExistsRequest request = new NamespaceExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "non_existent_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testTableExists() throws IOException {
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog/test_db/test_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        TableExistsRequest request = new TableExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "test_table"}));
        namespace.tableExists(request);
    }

    @Test
    public void testTableExistsNonExistent() {
        TableExistsRequest request = new TableExistsRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "non_existent_table"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.tableExists(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Table does not exist"));
    }

    @Test
    public void testListTables() throws IOException {
        CreateTableRequest createRequest1 = new CreateTableRequest();
        createRequest1.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "table1"}));
        createRequest1.setLocation(tmpDirBase + "/test_catalog/test_db/table1.lance");
        createRequest1.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest1, testData);
        CreateTableRequest createRequest2 = new CreateTableRequest();
        createRequest2.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "table2"}));
        createRequest2.setLocation(tmpDirBase + "/test_catalog/test_db/table2.lance");
        createRequest2.setSchema(TestHelper.createTestSchema());
        namespace.createTable(createRequest2, testData);
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        ListTablesResponse response = namespace.listTables(request);
        Assertions.assertEquals((int)2, (int)response.getTables().size());
        Assertions.assertTrue((boolean)response.getTables().contains("table1"));
        Assertions.assertTrue((boolean)response.getTables().contains("table2"));
    }

    @Test
    public void testListTablesEmpty() {
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        ListTablesResponse response = namespace.listTables(request);
        Assertions.assertEquals((int)0, (int)response.getTables().size());
    }

    @Test
    public void testListTablesWithPagination() throws IOException {
        for (int i = 1; i <= 5; ++i) {
            CreateTableRequest createRequest = new CreateTableRequest();
            createRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db", "table" + i}));
            createRequest.setLocation(tmpDirBase + "/test_catalog/test_db/table" + i + ".lance");
            createRequest.setSchema(TestHelper.createTestSchema());
            byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
            namespace.createTable(createRequest, testData);
        }
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        request.setLimit(Integer.valueOf(3));
        ListTablesResponse response = namespace.listTables(request);
        Assertions.assertEquals((int)3, (int)response.getTables().size());
        Assertions.assertTrue((response.getPageToken() != null && !response.getPageToken().isEmpty() ? 1 : 0) != 0);
        ListTablesRequest nextRequest = new ListTablesRequest();
        nextRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "test_db"}));
        nextRequest.setPageToken(response.getPageToken());
        ListTablesResponse nextResponse = namespace.listTables(nextRequest);
        Assertions.assertEquals((int)2, (int)nextResponse.getTables().size());
        Assertions.assertTrue((nextResponse.getPageToken() == null || nextResponse.getPageToken().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testListTablesWithCustomDatabase() throws IOException {
        CreateNamespaceRequest nsRequest = new CreateNamespaceRequest();
        nsRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "custom_db"}));
        nsRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(nsRequest);
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog", "custom_db", "custom_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog/custom_db/custom_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "custom_db"}));
        ListTablesResponse response = namespace.listTables(request);
        Assertions.assertEquals((int)1, (int)response.getTables().size());
        Assertions.assertTrue((boolean)response.getTables().contains("custom_table"));
    }

    @Test
    public void testListTablesNonExistentDatabase() {
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"test_catalog", "non_existent_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.listTables(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Database test_catalog.non_existent_db doesn't exist"));
    }

    @Test
    public void testListTablesNonExistentCatalog() {
        ListTablesRequest request = new ListTablesRequest();
        request.setId(Lists.list((Object[])new String[]{"non_existent_catalog", "test_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.listTables(request));
        Assertions.assertTrue((boolean)error.getMessage().contains("Catalog non_existent_catalog doesn't exist"));
    }

    @Test
    public void testDropNamespaceBasicDatabase() throws IOException {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic_db"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(catalogRequest);
        CreateNamespaceRequest dbRequest = new CreateNamespaceRequest();
        dbRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic_db", "test_db"}));
        dbRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        HashMap properties = Maps.newHashMap();
        properties.put("database.description", "Test database for dropping");
        properties.put("custom_param", "custom_value");
        dbRequest.setProperties((Map)properties);
        namespace.createNamespace(dbRequest);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic_db", "test_db"}));
        DropNamespaceResponse response = namespace.dropNamespace(dropRequest);
        Assertions.assertEquals((Object)"Test database for dropping", response.getProperties().get("database.description"));
        Assertions.assertEquals((Object)"custom_value", response.getProperties().get("custom_param"));
        NamespaceExistsRequest existsRequest = new NamespaceExistsRequest();
        existsRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic_db", "test_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(existsRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testDropNamespaceBasicCatalog() {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        HashMap properties = Maps.newHashMap();
        properties.put("description", "Test catalog for dropping");
        catalogRequest.setProperties((Map)properties);
        namespace.createNamespace(catalogRequest);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic"}));
        dropRequest.setBehavior(DropNamespaceRequest.BehaviorEnum.CASCADE);
        DropNamespaceResponse response = namespace.dropNamespace(dropRequest);
        Assertions.assertEquals((Object)"Test catalog for dropping", response.getProperties().get("description"));
        NamespaceExistsRequest existsRequest = new NamespaceExistsRequest();
        existsRequest.setId(Lists.list((Object[])new String[]{"test_catalog_basic"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(existsRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testDropNamespaceSkipMode() {
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"non_existent_catalog", "non_existent_db"}));
        dropRequest.setMode(DropNamespaceRequest.ModeEnum.SKIP);
        DropNamespaceResponse response = namespace.dropNamespace(dropRequest);
        Assertions.assertEquals((int)0, (int)response.getProperties().size());
    }

    @Test
    public void testDropNamespaceFailMode() {
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"non_existent_catalog", "non_existent_db"}));
        dropRequest.setMode(DropNamespaceRequest.ModeEnum.FAIL);
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.dropNamespace(dropRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("doesn't exist"));
    }

    @Test
    public void testDropDatabaseRestrictWithTables() throws IOException {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(catalogRequest);
        CreateNamespaceRequest dbRequest = new CreateNamespaceRequest();
        dbRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict", "test_db"}));
        dbRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(dbRequest);
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict", "test_db", "test_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog_restrict/test_db/test_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict", "test_db"}));
        dropRequest.setBehavior(DropNamespaceRequest.BehaviorEnum.RESTRICT);
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.dropNamespace(dropRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Database test_catalog_restrict.test_db is not empty"));
        Assertions.assertTrue((boolean)error.getMessage().contains("Contains 1 tables"));
    }

    @Test
    public void testDropCatalogRestrictWithDatabases() {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict_db"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(catalogRequest);
        CreateNamespaceRequest dbRequest = new CreateNamespaceRequest();
        dbRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict_db", "test_db"}));
        dbRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(dbRequest);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_restrict_db"}));
        dropRequest.setBehavior(DropNamespaceRequest.BehaviorEnum.RESTRICT);
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.dropNamespace(dropRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("is not empty"));
        Assertions.assertTrue((boolean)error.getMessage().contains("databases"));
    }

    @Test
    public void testDropDatabaseCascadeWithTables() throws IOException {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(catalogRequest);
        CreateNamespaceRequest dbRequest = new CreateNamespaceRequest();
        dbRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db", "test_db"}));
        dbRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(dbRequest);
        CreateTableRequest createRequest1 = new CreateTableRequest();
        createRequest1.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db", "test_db", "table1"}));
        createRequest1.setLocation(tmpDirBase + "/test_catalog_cascade_db/test_db/table1.lance");
        createRequest1.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest1, testData);
        CreateTableRequest createRequest2 = new CreateTableRequest();
        createRequest2.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db", "test_db", "table2"}));
        createRequest2.setLocation(tmpDirBase + "/test_catalog_cascade_db/test_db/table2.lance");
        createRequest2.setSchema(TestHelper.createTestSchema());
        namespace.createTable(createRequest2, testData);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db", "test_db"}));
        dropRequest.setBehavior(DropNamespaceRequest.BehaviorEnum.CASCADE);
        DropNamespaceResponse response = namespace.dropNamespace(dropRequest);
        Assertions.assertTrue((boolean)response.getProperties().containsKey("database.location-uri"));
        NamespaceExistsRequest existsRequest = new NamespaceExistsRequest();
        existsRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade_db", "test_db"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(existsRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }

    @Test
    public void testDropCatalogCascadeWithDatabasesAndTables() throws IOException {
        CreateNamespaceRequest catalogRequest = new CreateNamespaceRequest();
        catalogRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade"}));
        catalogRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(catalogRequest);
        CreateNamespaceRequest dbRequest = new CreateNamespaceRequest();
        dbRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade", "test_db"}));
        dbRequest.setMode(CreateNamespaceRequest.ModeEnum.CREATE);
        namespace.createNamespace(dbRequest);
        CreateTableRequest createRequest = new CreateTableRequest();
        createRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade", "test_db", "test_table"}));
        createRequest.setLocation(tmpDirBase + "/test_catalog_cascade/test_db/test_table.lance");
        createRequest.setSchema(TestHelper.createTestSchema());
        byte[] testData = TestHelper.createTestArrowData((BufferAllocator)allocator);
        namespace.createTable(createRequest, testData);
        DropNamespaceRequest dropRequest = new DropNamespaceRequest();
        dropRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade"}));
        dropRequest.setBehavior(DropNamespaceRequest.BehaviorEnum.CASCADE);
        DropNamespaceResponse response = namespace.dropNamespace(dropRequest);
        Assertions.assertTrue((boolean)response.getProperties().containsKey("catalog.location.uri"));
        NamespaceExistsRequest existsRequest = new NamespaceExistsRequest();
        existsRequest.setId(Lists.list((Object[])new String[]{"test_catalog_cascade"}));
        Exception error = (Exception)Assertions.assertThrows(LanceNamespaceException.class, () -> namespace.namespaceExists(existsRequest));
        Assertions.assertTrue((boolean)error.getMessage().contains("Namespace does not exist"));
    }
}

