/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.google.common.collect.ImmutableMap;
import com.lancedb.lance.namespace.hive3.Hive3NamespaceConfig;
import java.nio.file.Path;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestHive3NamespaceConfig {
    @TempDir
    Path tempDir;

    @Test
    public void testRootConfigurationDefault() {
        ImmutableMap properties = ImmutableMap.of();
        Hive3NamespaceConfig config = new Hive3NamespaceConfig((Map)properties);
        Assertions.assertEquals((Object)System.getProperty("user.dir"), (Object)config.getRoot());
    }

    @Test
    public void testRootConfigurationCustom() {
        String customRoot = this.tempDir.toString();
        ImmutableMap properties = ImmutableMap.of((Object)"root", (Object)customRoot);
        Hive3NamespaceConfig config = new Hive3NamespaceConfig((Map)properties);
        Assertions.assertEquals((Object)customRoot, (Object)config.getRoot());
    }

    @Test
    public void testRootConfigurationTrailingSlashStripped() {
        String customRoot = this.tempDir.toString() + "/";
        ImmutableMap properties = ImmutableMap.of((Object)"root", (Object)customRoot);
        Hive3NamespaceConfig config = new Hive3NamespaceConfig((Map)properties);
        Assertions.assertEquals((Object)this.tempDir.toString(), (Object)config.getRoot());
    }

    @Test
    public void testOtherConfigurationValues() {
        ImmutableMap properties = ImmutableMap.of((Object)"root", (Object)"/custom/root", (Object)"client.pool-size", (Object)"5", (Object)"storage.s3.region", (Object)"us-west-2");
        Hive3NamespaceConfig config = new Hive3NamespaceConfig((Map)properties);
        Assertions.assertEquals((Object)"/custom/root", (Object)config.getRoot());
        Assertions.assertEquals((int)5, (int)config.getClientPoolSize());
        Assertions.assertEquals((Object)"us-west-2", config.getStorageOptions().get("s3.region"));
    }
}

