/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.hive3;

import com.google.common.collect.Maps;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.hive3.Hive3ClientPool;
import com.lancedb.lance.namespace.hive3.Hive3ErrorType;
import com.lancedb.lance.namespace.util.CommonUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;

public class Hive3Util {
    public static Catalog getCatalogOrNull(Hive3ClientPool clientPool, String catalog) {
        try {
            return (Catalog)clientPool.run(client -> client.getCatalog(catalog));
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serviceUnavailable((String)e.getMessage(), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static Catalog getCatalogOrThrowNotFoundException(Hive3ClientPool clientPool, String catalog) {
        Catalog catalogObj = Hive3Util.getCatalogOrNull(clientPool, catalog);
        if (catalogObj == null) {
            throw LanceNamespaceException.notFound((String)String.format("Catalog %s doesn't exist", catalog), (String)Hive3ErrorType.UnknownCatalog.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
        return catalogObj;
    }

    public static Database getDatabaseOrNull(Hive3ClientPool clientPool, String catalog, String db) {
        try {
            return (Database)clientPool.run(client -> client.getDatabase(catalog, db));
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serviceUnavailable((String)e.getMessage(), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static Database getDatabaseOrNull(Hive3ClientPool clientPool, String db) {
        try {
            return (Database)clientPool.run(client -> client.getDatabase(db));
        }
        catch (NoSuchObjectException e) {
            return null;
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serviceUnavailable((String)e.getMessage(), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static void setDatabaseProperties(Database database, Supplier<String> warehouseLocation, String dbName, Map<String, String> properties) {
        HashMap parameters = Maps.newHashMap();
        properties.forEach((k, v) -> {
            if (k.equals("database.description")) {
                database.setDescription(v);
            } else if (k.equals("database.location-uri")) {
                database.setLocationUri(v);
            } else if (k.equals("database.owner")) {
                database.setOwnerName(v);
            } else if (k.equals("database.owner-type") && v != null) {
                database.setOwnerType(PrincipalType.valueOf((String)v));
            } else if (v != null) {
                parameters.put(k, v);
            }
        });
        if (!database.isSetLocationUri()) {
            String location = Hive3Util.databaseLocation(warehouseLocation.get(), dbName);
            database.setLocationUri(location);
            properties.put("database.location-uri", location);
        }
        if (!database.isSetOwnerName()) {
            String user = Hive3Util.hadoopUser();
            database.setOwnerName(user);
            properties.put("database.owner", user);
        }
        if (!database.isSetOwnerType()) {
            database.setOwnerType(PrincipalType.USER);
            properties.put("database.owner-type", PrincipalType.USER.name());
        }
        database.setParameters((Map)parameters);
    }

    public static String databaseLocation(String warehouse, String dbName) {
        return String.format("%s/%s", CommonUtil.makeQualified((String)warehouse), dbName);
    }

    public static String hadoopUser() {
        try {
            return UserGroupInformation.getCurrentUser().getUserName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Table> getTable(Hive3ClientPool clientPool, String db, String table) {
        try {
            return Optional.of((Table)clientPool.run(client -> client.getTable(db, table)));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serviceUnavailable((String)e.getMessage(), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static Optional<Table> getTable(Hive3ClientPool clientPool, String catalog, String db, String table) {
        try {
            return Optional.of((Table)clientPool.run(client -> client.getTable(catalog, db, table)));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (InterruptedException | TException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw LanceNamespaceException.serviceUnavailable((String)e.getMessage(), (String)Hive3ErrorType.HiveMetaStoreError.getType(), (String)"", (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static void validateLanceTable(Table table) {
        Map params = table.getParameters();
        if (params == null || !"lance".equalsIgnoreCase((String)params.get("table_type"))) {
            throw LanceNamespaceException.badRequest((String)String.format("Table %s.%s is not a Lance table", table.getDbName(), table.getTableName()), (String)Hive3ErrorType.InvalidLanceTable.getType(), (String)String.format("%s.%s", table.getDbName(), table.getTableName()), (String)CommonUtil.formatCurrentStackTrace());
        }
    }

    public static Map<String, String> createLanceTableParams(Map<String, String> properties) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (properties != null) {
            params.putAll(properties);
        }
        params.put("table_type", "lance");
        params.putIfAbsent("managed_by", "storage");
        return params;
    }
}

