/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.api;

import com.lancedb.lance.namespace.server.springboot.api.ApiUtil;
import com.lancedb.lance.namespace.server.springboot.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.server.springboot.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.server.springboot.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.server.springboot.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.server.springboot.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.server.springboot.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.server.springboot.model.ErrorResponse;
import com.lancedb.lance.namespace.server.springboot.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.server.springboot.model.ListTablesResponse;
import com.lancedb.lance.namespace.server.springboot.model.NamespaceExistsRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Namespace", description="Operations that are related to a namespace ")
public interface NamespaceApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="createNamespace", summary="Create a new namespace", description="Create new namespace `id`.  During the creation process, the implementation may modify user-provided `properties`,  such as adding additional properties like `created_at` to user-provided properties,  omitting any specific property, or performing actions based on any property value. ", tags={"Namespace", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Result of creating a namespace", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateNamespaceResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="406", description="Not Acceptable / Unsupported Operation. The server does not support this operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/namespace/{id}/create"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<CreateNamespaceResponse> createNamespace(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="CreateNamespaceRequest", description="", required=true) @Valid @RequestBody CreateNamespaceRequest createNamespaceRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"properties\" : { \"key\" : \"properties\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="describeNamespace", summary="Describe a namespace", description="Describe the detailed information for namespace `id`. ", tags={"Namespace", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Returns a namespace, as well as any properties stored on the namespace if namespace properties are supported by the server.", content={@Content(mediaType="application/json", schema=@Schema(implementation=DescribeNamespaceResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/namespace/{id}/describe"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DescribeNamespaceResponse> describeNamespace(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DescribeNamespaceRequest", description="", required=true) @Valid @RequestBody DescribeNamespaceRequest describeNamespaceRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"properties\" : { \"owner\" : \"Ralph\", \"created_at\" : \"1452120468\" } }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="dropNamespace", summary="Drop a namespace", description="Drop namespace `id` from its parent namespace. ", tags={"Namespace", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Result of dropping a namespace", content={@Content(mediaType="application/json", schema=@Schema(implementation=DropNamespaceResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/namespace/{id}/drop"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DropNamespaceResponse> dropNamespace(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DropNamespaceRequest", description="", required=true) @Valid @RequestBody DropNamespaceRequest dropNamespaceRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"properties\" : { \"key\" : \"properties\" }, \"transactionId\" : [ \"transactionId\", \"transactionId\" ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="listNamespaces", summary="List namespaces", description="List all child namespace names of the parent namespace `id`.  REST NAMESPACE ONLY REST namespace uses GET to perform this operation without a request body. It passes in the `ListNamespacesRequest` information in the following way: - `id`: pass through path parameter of the same name - `page_token`: pass through query parameter of the same name - `limit`: pass through query parameter of the same name ", tags={"Namespace", "Metadata"}, responses={@ApiResponse(responseCode="200", description="A list of namespaces", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListNamespacesResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="406", description="Not Acceptable / Unsupported Operation. The server does not support this operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/v1/namespace/{id}/list"}, produces={"application/json"})
    default public ResponseEntity<ListNamespacesResponse> listNamespaces(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="page_token", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_token", required=false) Optional<String> pageToken, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) Optional<Integer> limit) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"page_token\" : \"page_token\", \"namespaces\" : [ \"namespaces\", \"namespaces\" ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="listTables", summary="List tables in a namespace", description="List all child table names of the parent namespace `id`.  REST NAMESPACE ONLY REST namespace uses GET to perform this operation without a request body. It passes in the `ListTablesRequest` information in the following way: - `id`: pass through path parameter of the same name - `page_token`: pass through query parameter of the same name - `limit`: pass through query parameter of the same name ", tags={"Namespace", "Table", "Metadata"}, responses={@ApiResponse(responseCode="200", description="A list of tables", content={@Content(mediaType="application/json", schema=@Schema(implementation=ListTablesResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="406", description="Not Acceptable / Unsupported Operation. The server does not support this operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.GET}, value={"/v1/namespace/{id}/table/list"}, produces={"application/json"})
    default public ResponseEntity<ListTablesResponse> listTables(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter, @Parameter(name="page_token", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_token", required=false) Optional<String> pageToken, @Parameter(name="limit", description="", in=ParameterIn.QUERY) @Valid @RequestParam(value="limit", required=false) Optional<Integer> limit) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"tables\" : [ \"tables\", \"tables\" ], \"page_token\" : \"page_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="namespaceExists", summary="Check if a namespace exists", description="Check if namespace `id` exists.  This operation must behave exactly like the DescribeNamespace API,  except it does not contain a response body. ", tags={"Namespace", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Success, no content"), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/namespace/{id}/exists"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<Void> namespaceExists(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="NamespaceExistsRequest", description="", required=true) @Valid @RequestBody NamespaceExistsRequest namespaceExistsRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

