/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.api;

import com.lancedb.lance.namespace.server.springboot.api.ApiUtil;
import com.lancedb.lance.namespace.server.springboot.model.AlterTransactionRequest;
import com.lancedb.lance.namespace.server.springboot.model.AlterTransactionResponse;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTransactionRequest;
import com.lancedb.lance.namespace.server.springboot.model.DescribeTransactionResponse;
import com.lancedb.lance.namespace.server.springboot.model.ErrorResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Transaction", description="Operations that are related to a transaction ")
public interface TransactionApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="alterTransaction", summary="Alter information of a transaction.", description="Alter a transaction with a list of actions such as setting status or properties. The server should either succeed and apply all actions, or fail and apply no action. ", tags={"Transaction", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Response of AlterTransaction", content={@Content(mediaType="application/json", schema=@Schema(implementation=AlterTransactionResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="409", description="The request conflicts with the current state of the target resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/transaction/{id}/alter"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<AlterTransactionResponse> alterTransaction(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="AlterTransactionRequest", description="", required=true) @Valid @RequestBody AlterTransactionRequest alterTransactionRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"properties\" : { \"key\" : \"properties\" }, \"status\" : \"QUEUED\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="describeTransaction", summary="Describe information about a transaction", description="Return a detailed information for a given transaction ", tags={"Transaction", "Metadata"}, responses={@ApiResponse(responseCode="200", description="Response of GetTransaction", content={@Content(mediaType="application/json", schema=@Schema(implementation=DescribeTransactionResponse.class))}), @ApiResponse(responseCode="400", description="Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="401", description="Unauthorized. The request lacks valid authentication credentials for the operation.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Forbidden. Authenticated user does not have the necessary permissions.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="A server-side problem that means can not find the specified resource.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="503", description="The service is not ready to handle the request. The client should wait and retry. The service may additionally send a Retry-After header to indicate when to retry.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="5XX", description="A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class))})})
    @RequestMapping(method={RequestMethod.POST}, value={"/v1/transaction/{id}/describe"}, produces={"application/json"}, consumes={"application/json"})
    default public ResponseEntity<DescribeTransactionResponse> describeTransaction(@Parameter(name="id", description="`string identifier` of an object in a namespace, following the Lance Namespace spec. When the value is equal to the delimiter, it represents the root namespace. For example, `v1/namespace/$/list` performs a `ListNamespace` on the root namespace. ", required=true, in=ParameterIn.PATH) @PathVariable(value="id") String id, @Parameter(name="DescribeTransactionRequest", description="", required=true) @Valid @RequestBody DescribeTransactionRequest describeTransactionRequest, @Parameter(name="delimiter", description="An optional delimiter of the `string identifier`, following the Lance Namespace spec. When not specified, the `$` delimiter must be used. ", in=ParameterIn.QUERY) @Valid @RequestParam(value="delimiter", required=false) Optional<String> delimiter) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"properties\" : { \"key\" : \"properties\" }, \"status\" : \"QUEUED\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"code\" : 404, \"instance\" : \"/login/log/abc123\", \"detail\" : \"Authentication failed due to incorrect username or password\", \"error\" : \"Incorrect username or password\", \"type\" : \"/errors/incorrect-user-pass\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED);
    }
}

