/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.FtsQuery;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="BooleanQuery", description="Boolean query with must, should, and must_not clauses")
public class BooleanQuery {
    @Valid
    private @Valid List<@Valid FtsQuery> must = new ArrayList<FtsQuery>();
    @Valid
    private @Valid List<@Valid FtsQuery> mustNot = new ArrayList<FtsQuery>();
    @Valid
    private @Valid List<@Valid FtsQuery> should = new ArrayList<FtsQuery>();

    public BooleanQuery() {
    }

    public BooleanQuery(List<@Valid FtsQuery> must, List<@Valid FtsQuery> mustNot, List<@Valid FtsQuery> should) {
        this.must = must;
        this.mustNot = mustNot;
        this.should = should;
    }

    public BooleanQuery must(List<@Valid FtsQuery> must) {
        this.must = must;
        return this;
    }

    public BooleanQuery addMustItem(FtsQuery mustItem) {
        if (this.must == null) {
            this.must = new ArrayList<FtsQuery>();
        }
        this.must.add(mustItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="must", description="Queries that must match (AND)", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="must")
    public @NotNull @Valid List<@Valid FtsQuery> getMust() {
        return this.must;
    }

    public void setMust(List<@Valid FtsQuery> must) {
        this.must = must;
    }

    public BooleanQuery mustNot(List<@Valid FtsQuery> mustNot) {
        this.mustNot = mustNot;
        return this;
    }

    public BooleanQuery addMustNotItem(FtsQuery mustNotItem) {
        if (this.mustNot == null) {
            this.mustNot = new ArrayList<FtsQuery>();
        }
        this.mustNot.add(mustNotItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="must_not", description="Queries that must not match (NOT)", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="must_not")
    public @NotNull @Valid List<@Valid FtsQuery> getMustNot() {
        return this.mustNot;
    }

    public void setMustNot(List<@Valid FtsQuery> mustNot) {
        this.mustNot = mustNot;
    }

    public BooleanQuery should(List<@Valid FtsQuery> should) {
        this.should = should;
        return this;
    }

    public BooleanQuery addShouldItem(FtsQuery shouldItem) {
        if (this.should == null) {
            this.should = new ArrayList<FtsQuery>();
        }
        this.should.add(shouldItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="should", description="Queries that should match (OR)", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="should")
    public @NotNull @Valid List<@Valid FtsQuery> getShould() {
        return this.should;
    }

    public void setShould(List<@Valid FtsQuery> should) {
        this.should = should;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanQuery booleanQuery = (BooleanQuery)o;
        return Objects.equals(this.must, booleanQuery.must) && Objects.equals(this.mustNot, booleanQuery.mustNot) && Objects.equals(this.should, booleanQuery.should);
    }

    public int hashCode() {
        return Objects.hash(this.must, this.mustNot, this.should);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BooleanQuery {\n");
        sb.append("    must: ").append(this.toIndentedString(this.must)).append("\n");
        sb.append("    mustNot: ").append(this.toIndentedString(this.mustNot)).append("\n");
        sb.append("    should: ").append(this.toIndentedString(this.should)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

