/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.FtsQuery;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

@Schema(name="BoostQuery", description="Boost query that scores documents matching positive query higher and negative query lower")
public class BoostQuery {
    private FtsQuery positive;
    private FtsQuery negative;
    private Float negativeBoost = Float.valueOf(0.5f);

    public BoostQuery() {
    }

    public BoostQuery(FtsQuery positive, FtsQuery negative) {
        this.positive = positive;
        this.negative = negative;
    }

    public BoostQuery positive(FtsQuery positive) {
        this.positive = positive;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="positive", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="positive")
    public FtsQuery getPositive() {
        return this.positive;
    }

    public void setPositive(FtsQuery positive) {
        this.positive = positive;
    }

    public BoostQuery negative(FtsQuery negative) {
        this.negative = negative;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="negative", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="negative")
    public FtsQuery getNegative() {
        return this.negative;
    }

    public void setNegative(FtsQuery negative) {
        this.negative = negative;
    }

    public BoostQuery negativeBoost(Float negativeBoost) {
        this.negativeBoost = negativeBoost;
        return this;
    }

    @Schema(name="negative_boost", description="Boost factor for negative query (default: 0.5)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="negative_boost")
    public Float getNegativeBoost() {
        return this.negativeBoost;
    }

    public void setNegativeBoost(Float negativeBoost) {
        this.negativeBoost = negativeBoost;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoostQuery boostQuery = (BoostQuery)o;
        return Objects.equals(this.positive, boostQuery.positive) && Objects.equals(this.negative, boostQuery.negative) && Objects.equals(this.negativeBoost, boostQuery.negativeBoost);
    }

    public int hashCode() {
        return Objects.hash(this.positive, this.negative, this.negativeBoost);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BoostQuery {\n");
        sb.append("    positive: ").append(this.toIndentedString(this.positive)).append("\n");
        sb.append("    negative: ").append(this.toIndentedString(this.negative)).append("\n");
        sb.append("    negativeBoost: ").append(this.toIndentedString(this.negativeBoost)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

