/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@Schema(name="CreateEmptyTableRequest", description="Request for creating an empty table. ")
public class CreateEmptyTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String location;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();

    public CreateEmptyTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public CreateEmptyTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public CreateEmptyTableRequest location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="location", description="Optional storage location for the table. If not provided, the namespace implementation should determine the table location. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public CreateEmptyTableRequest properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateEmptyTableRequest putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateEmptyTableRequest createEmptyTableRequest = (CreateEmptyTableRequest)o;
        return Objects.equals(this.id, createEmptyTableRequest.id) && Objects.equals(this.location, createEmptyTableRequest.location) && Objects.equals(this.properties, createEmptyTableRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.location, this.properties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateEmptyTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

