/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(name="CreateEmptyTableResponse", description="Response for creating an empty table. ")
public class CreateEmptyTableResponse {
    private String location;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();
    @Valid
    private Map<String, String> storageOptions = new HashMap<String, String>();

    public CreateEmptyTableResponse location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="location", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public CreateEmptyTableResponse properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateEmptyTableResponse putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public CreateEmptyTableResponse storageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
        return this;
    }

    public CreateEmptyTableResponse putStorageOptionsItem(String key, String storageOptionsItem) {
        if (this.storageOptions == null) {
            this.storageOptions = new HashMap<String, String>();
        }
        this.storageOptions.put(key, storageOptionsItem);
        return this;
    }

    @Schema(name="storage_options", description="Configuration options to be used to access storage. The available options depend on the type of storage in use. These will be passed directly to Lance to initialize storage access. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="storage_options")
    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }

    public void setStorageOptions(Map<String, String> storageOptions) {
        this.storageOptions = storageOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateEmptyTableResponse createEmptyTableResponse = (CreateEmptyTableResponse)o;
        return Objects.equals(this.location, createEmptyTableResponse.location) && Objects.equals(this.properties, createEmptyTableResponse.properties) && Objects.equals(this.storageOptions, createEmptyTableResponse.storageOptions);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.properties, this.storageOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateEmptyTableResponse {\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    storageOptions: ").append(this.toIndentedString(this.storageOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

