/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateNamespaceRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private ModeEnum mode;
    @Valid
    private Map<String, String> properties = new HashMap<String, String>();

    public CreateNamespaceRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public CreateNamespaceRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public CreateNamespaceRequest mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="mode", description="There are three modes when trying to create a namespace, to differentiate the behavior when a namespace of the same name already exists:   * create: the operation fails with 409.   * exist_ok: the operation succeeds and the existing namespace is kept.   * overwrite: the existing namespace is dropped and a new empty namespace with this name is created. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="mode")
    public ModeEnum getMode() {
        return this.mode;
    }

    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public CreateNamespaceRequest properties(Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public CreateNamespaceRequest putPropertiesItem(String key, String propertiesItem) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, propertiesItem);
        return this;
    }

    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateNamespaceRequest createNamespaceRequest = (CreateNamespaceRequest)o;
        return Objects.equals(this.id, createNamespaceRequest.id) && Objects.equals((Object)this.mode, (Object)createNamespaceRequest.mode) && Objects.equals(this.properties, createNamespaceRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.mode, this.properties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateNamespaceRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        CREATE("create"),
        EXIST_OK("exist_ok"),
        OVERWRITE("overwrite");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

