/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="DeleteFromTableRequest", description="Delete data from table based on a SQL predicate. Returns the number of rows that were deleted. ")
public class DeleteFromTableRequest {
    @Valid
    private List<String> id = new ArrayList<String>();
    private String predicate;

    public DeleteFromTableRequest() {
    }

    public DeleteFromTableRequest(String predicate) {
        this.predicate = predicate;
    }

    public DeleteFromTableRequest id(List<String> id) {
        this.id = id;
        return this;
    }

    public DeleteFromTableRequest addIdItem(String idItem) {
        if (this.id == null) {
            this.id = new ArrayList<String>();
        }
        this.id.add(idItem);
        return this;
    }

    @Schema(name="id", description="The namespace identifier", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public List<String> getId() {
        return this.id;
    }

    public void setId(List<String> id) {
        this.id = id;
    }

    public DeleteFromTableRequest predicate(String predicate) {
        this.predicate = predicate;
        return this;
    }

    @NotNull
    @Schema(name="predicate", description="SQL predicate to filter rows for deletion", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="predicate")
    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteFromTableRequest deleteFromTableRequest = (DeleteFromTableRequest)o;
        return Objects.equals(this.id, deleteFromTableRequest.id) && Objects.equals(this.predicate, deleteFromTableRequest.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.predicate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteFromTableRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    predicate: ").append(this.toIndentedString(this.predicate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

