/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.JsonArrowField;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="JsonArrowDataType", description="JSON representation of an Apache Arrow DataType")
public class JsonArrowDataType {
    @Valid
    private @Valid List<@Valid JsonArrowField> fields = new ArrayList<JsonArrowField>();
    private Long length;
    private String type;

    public JsonArrowDataType() {
    }

    public JsonArrowDataType(String type) {
        this.type = type;
    }

    public JsonArrowDataType fields(List<@Valid JsonArrowField> fields) {
        this.fields = fields;
        return this;
    }

    public JsonArrowDataType addFieldsItem(JsonArrowField fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<JsonArrowField>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Valid
    @Schema(name="fields", description="Fields for complex types like Struct, Union, etc.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fields")
    public @Valid List<@Valid JsonArrowField> getFields() {
        return this.fields;
    }

    public void setFields(List<@Valid JsonArrowField> fields) {
        this.fields = fields;
    }

    public JsonArrowDataType length(Long length) {
        this.length = length;
        return this;
    }

    @Min(value=0L)
    @Schema(name="length", description="Length for fixed-size types", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="length")
    public @Min(value=0L) Long getLength() {
        return this.length;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public JsonArrowDataType type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="type", description="The data type name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrowDataType jsonArrowDataType = (JsonArrowDataType)o;
        return Objects.equals(this.fields, jsonArrowDataType.fields) && Objects.equals(this.length, jsonArrowDataType.length) && Objects.equals(this.type, jsonArrowDataType.type);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.length, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonArrowDataType {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    length: ").append(this.toIndentedString(this.length)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

