/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.JsonArrowDataType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(name="JsonArrowField", description="JSON representation of an Apache Arrow field. ")
public class JsonArrowField {
    @Valid
    private Map<String, String> metadata = new HashMap<String, String>();
    private String name;
    private Boolean nullable;
    private JsonArrowDataType type;

    public JsonArrowField() {
    }

    public JsonArrowField(String name, Boolean nullable, JsonArrowDataType type) {
        this.name = name;
        this.nullable = nullable;
        this.type = type;
    }

    public JsonArrowField metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public JsonArrowField putMetadataItem(String key, String metadataItem) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, String>();
        }
        this.metadata.put(key, metadataItem);
        return this;
    }

    @Schema(name="metadata", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public JsonArrowField name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JsonArrowField nullable(Boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    @NotNull
    @Schema(name="nullable", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="nullable")
    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public JsonArrowField type(JsonArrowDataType type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="type", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public JsonArrowDataType getType() {
        return this.type;
    }

    public void setType(JsonArrowDataType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArrowField jsonArrowField = (JsonArrowField)o;
        return Objects.equals(this.metadata, jsonArrowField.metadata) && Objects.equals(this.name, jsonArrowField.name) && Objects.equals(this.nullable, jsonArrowField.nullable) && Objects.equals(this.type, jsonArrowField.type);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.name, this.nullable, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonArrowField {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nullable: ").append(this.toIndentedString(this.nullable)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

