/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.server.springboot.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.lancedb.lance.namespace.server.springboot.model.TableVersion;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ListTableVersionsResponse {
    @Valid
    private @Valid List<@Valid TableVersion> versions = new ArrayList<TableVersion>();
    private String pageToken;

    public ListTableVersionsResponse() {
    }

    public ListTableVersionsResponse(List<@Valid TableVersion> versions) {
        this.versions = versions;
    }

    public ListTableVersionsResponse versions(List<@Valid TableVersion> versions) {
        this.versions = versions;
        return this;
    }

    public ListTableVersionsResponse addVersionsItem(TableVersion versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<TableVersion>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="versions", description="List of table versions", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="versions")
    public @NotNull @Valid List<@Valid TableVersion> getVersions() {
        return this.versions;
    }

    public void setVersions(List<@Valid TableVersion> versions) {
        this.versions = versions;
    }

    public ListTableVersionsResponse pageToken(String pageToken) {
        this.pageToken = pageToken;
        return this;
    }

    @Schema(name="page_token", description="An opaque token that allows pagination for list operations (e.g. ListNamespaces).  For an initial request of a list operation,  if the implementation cannot return all items in one response, or if there are more items than the page limit specified in the request, the implementation must return a page token in the response, indicating there are more results available.  After the initial request,  the value of the page token from each response must be used as the page token value for the next request.  Caller must interpret either `null`,  missing value or empty string value of the page token from the implementation's response as the end of the listing results. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page_token")
    public String getPageToken() {
        return this.pageToken;
    }

    public void setPageToken(String pageToken) {
        this.pageToken = pageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTableVersionsResponse listTableVersionsResponse = (ListTableVersionsResponse)o;
        return Objects.equals(this.versions, listTableVersionsResponse.versions) && Objects.equals(this.pageToken, listTableVersionsResponse.pageToken);
    }

    public int hashCode() {
        return Objects.hash(this.versions, this.pageToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListTableVersionsResponse {\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("    pageToken: ").append(this.toIndentedString(this.pageToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

